/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.breakpoint;

import docking.DialogComponentProvider;
import ghidra.app.services.DebuggerLogicalBreakpointService;
import ghidra.async.AsyncUtils;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.trace.model.breakpoint.TraceBreakpointKind;
import ghidra.util.MessageType;
import ghidra.util.layout.PairLayout;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class DebuggerPlaceBreakpointDialog
extends DialogComponentProvider {
    private DebuggerLogicalBreakpointService service;
    private Program program;
    private Address address;
    private long length;
    private Set<TraceBreakpointKind> kinds;
    private JTextField fieldAddress;
    private JTextField fieldLength;
    private JComboBox<String> fieldKinds;

    public DebuggerPlaceBreakpointDialog() {
        super("Set Breakpoint", true, true, true, false);
        this.populateComponents();
    }

    protected void populateComponents() {
        JPanel panel = new JPanel((LayoutManager)new PairLayout(5, 5));
        panel.setBorder(new EmptyBorder(10, 10, 10, 10));
        JLabel labelAddress = new JLabel("Address");
        this.fieldAddress = new JTextField();
        panel.add(labelAddress);
        panel.add(this.fieldAddress);
        JLabel labelLength = new JLabel("Length");
        this.fieldLength = new JTextField();
        panel.add(labelLength);
        panel.add(this.fieldLength);
        JLabel labelKinds = new JLabel("Kinds");
        DefaultComboBoxModel<String> kindModel = new DefaultComboBoxModel<String>();
        kindModel.addElement(TraceBreakpointKind.TraceBreakpointKindSet.encode(Set.of(TraceBreakpointKind.SW_EXECUTE)));
        kindModel.addElement(TraceBreakpointKind.TraceBreakpointKindSet.encode(Set.of(TraceBreakpointKind.HW_EXECUTE)));
        kindModel.addElement(TraceBreakpointKind.TraceBreakpointKindSet.encode(Set.of(TraceBreakpointKind.READ)));
        kindModel.addElement(TraceBreakpointKind.TraceBreakpointKindSet.encode(Set.of(TraceBreakpointKind.WRITE)));
        kindModel.addElement(TraceBreakpointKind.TraceBreakpointKindSet.encode(Set.of(TraceBreakpointKind.READ, TraceBreakpointKind.WRITE)));
        this.fieldKinds = new JComboBox(kindModel);
        this.fieldKinds.setEditable(true);
        panel.add(labelKinds);
        panel.add(this.fieldKinds);
        this.addWorkPanel(panel);
        this.addOKButton();
        this.addCancelButton();
    }

    public void prompt(PluginTool tool, DebuggerLogicalBreakpointService service, String title, ProgramLocation loc, long length, Collection<TraceBreakpointKind> kinds) {
        this.service = service;
        this.program = loc.getProgram();
        this.address = loc.getAddress();
        this.length = length;
        this.kinds = Set.copyOf(kinds);
        this.fieldAddress.setText(this.address.toString());
        this.fieldLength.setText(Long.toUnsignedString(length));
        this.fieldKinds.setSelectedItem(TraceBreakpointKind.TraceBreakpointKindSet.encode(kinds));
        this.clearStatusText();
        this.setTitle(title);
        tool.showDialog((DialogComponentProvider)this);
    }

    protected void okCallback() {
        this.address = this.program.getAddressFactory().getAddress(this.fieldAddress.getText());
        if (this.address == null) {
            this.setStatusText("Invalid address: " + this.fieldAddress.getText());
            return;
        }
        try {
            this.length = Long.parseUnsignedLong(this.fieldLength.getText());
        }
        catch (NumberFormatException e) {
            this.setStatusText("Invalid length: " + e);
            return;
        }
        try {
            this.kinds = TraceBreakpointKind.TraceBreakpointKindSet.decode((String)((String)this.fieldKinds.getSelectedItem()), (boolean)true);
        }
        catch (IllegalArgumentException e) {
            this.setStatusText("Invalid kinds: " + e);
            return;
        }
        ProgramLocation loc = new ProgramLocation(this.program, this.address);
        ((CompletableFuture)this.service.placeBreakpointAt(loc, this.length, this.kinds).thenAccept(__ -> this.close())).exceptionally(ex -> {
            ex = AsyncUtils.unwrapThrowable((Throwable)ex);
            this.setStatusText(ex.getMessage(), MessageType.ERROR, true);
            return null;
        });
    }
}

