/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.breakpoint;

import docking.ComponentProvider;
import ghidra.app.plugin.core.debug.AbstractDebuggerPlugin;
import ghidra.app.plugin.core.debug.event.TraceActivatedPluginEvent;
import ghidra.app.plugin.core.debug.event.TraceClosedPluginEvent;
import ghidra.app.plugin.core.debug.event.TraceOpenedPluginEvent;
import ghidra.app.plugin.core.debug.gui.breakpoint.DebuggerBreakpointsProvider;
import ghidra.app.services.DebuggerLogicalBreakpointService;
import ghidra.app.services.DebuggerModelService;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;

@PluginInfo(shortDescription="Debugger breakpoints manager", description="GUI to manage breakpoints", category="Debugger", packageName="Debugger", status=PluginStatus.RELEASED, servicesRequired={DebuggerLogicalBreakpointService.class, DebuggerModelService.class}, eventsConsumed={TraceOpenedPluginEvent.class, TraceClosedPluginEvent.class, TraceActivatedPluginEvent.class})
public class DebuggerBreakpointsPlugin
extends AbstractDebuggerPlugin {
    protected DebuggerBreakpointsProvider provider;

    public DebuggerBreakpointsPlugin(PluginTool tool) {
        super(tool);
    }

    @Override
    protected void init() {
        super.init();
        this.provider = new DebuggerBreakpointsProvider(this);
    }

    protected void dispose() {
        this.provider.dispose();
        this.tool.removeComponentProvider((ComponentProvider)this.provider);
        super.dispose();
    }

    public void processEvent(PluginEvent event) {
        super.processEvent(event);
        if (event instanceof TraceOpenedPluginEvent) {
            TraceOpenedPluginEvent evt = (TraceOpenedPluginEvent)event;
            this.provider.traceOpened(evt.getTrace());
        } else if (event instanceof TraceClosedPluginEvent) {
            TraceClosedPluginEvent evt = (TraceClosedPluginEvent)event;
            this.provider.traceClosed(evt.getTrace());
        } else if (event instanceof TraceActivatedPluginEvent) {
            TraceActivatedPluginEvent evt = (TraceActivatedPluginEvent)event;
            this.provider.setTrace(evt.getActiveCoordinates().getTrace());
        }
    }
}

