/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.data.rtti;

import ghidra.app.cmd.data.AbstractCreateDataBackgroundCmd;
import ghidra.app.cmd.data.EHDataTypeUtilities;
import ghidra.app.cmd.data.TypeDescriptorModel;
import ghidra.app.cmd.data.rtti.CreateRtti1BackgroundCmd;
import ghidra.app.cmd.data.rtti.Rtti2Model;
import ghidra.app.cmd.data.rtti.RttiUtil;
import ghidra.app.util.datatype.microsoft.DataApplyOptions;
import ghidra.app.util.datatype.microsoft.DataValidationOptions;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.CancelledException;

public class CreateRtti2BackgroundCmd
extends AbstractCreateDataBackgroundCmd<Rtti2Model> {
    private static final String RTTI_2_NAME = "RTTI Base Class Array";
    private int rtti1Count;

    public CreateRtti2BackgroundCmd(Address address, int rtti1Count, DataValidationOptions validationOptions, DataApplyOptions applyOptions) {
        super("RTTIBaseClassArray", address, 1, validationOptions, applyOptions);
        this.rtti1Count = rtti1Count;
    }

    CreateRtti2BackgroundCmd(Rtti2Model rtti2Model, DataApplyOptions applyOptions) {
        super(rtti2Model, applyOptions);
    }

    @Override
    protected Rtti2Model createModel(Program program) {
        if (this.model == null || program != ((Rtti2Model)this.model).getProgram()) {
            this.model = new Rtti2Model(program, this.rtti1Count, this.getDataAddress(), this.validationOptions);
        }
        return (Rtti2Model)this.model;
    }

    @Override
    protected boolean createAssociatedData() throws CancelledException {
        return this.createRtti1s();
    }

    private boolean createRtti1s() throws CancelledException {
        int itemCount = ((Rtti2Model)this.model).getCount();
        for (int rtti1Index = 0; rtti1Index < itemCount; ++rtti1Index) {
            try {
                if (this.createRtti1(rtti1Index)) continue;
                return false;
            }
            catch (InvalidDataTypeException e) {
                return false;
            }
        }
        return true;
    }

    private boolean createRtti1(int rtti1Index) throws CancelledException, InvalidDataTypeException {
        this.monitor.checkCanceled();
        CreateRtti1BackgroundCmd cmd = new CreateRtti1BackgroundCmd(((Rtti2Model)this.model).getRtti1Model(rtti1Index), this.applyOptions);
        return cmd.applyTo((DomainObject)((Rtti2Model)this.model).getProgram(), this.monitor);
    }

    @Override
    protected boolean createMarkup() throws CancelledException, InvalidDataTypeException {
        this.monitor.checkCanceled();
        Program program = ((Rtti2Model)this.model).getProgram();
        TypeDescriptorModel rtti0Model = ((Rtti2Model)this.model).getRtti0Model();
        if (rtti0Model == null) {
            return true;
        }
        this.monitor.checkCanceled();
        boolean shouldCreateComment = true;
        if (this.applyOptions.shouldCreateLabel()) {
            shouldCreateComment = RttiUtil.createSymbolFromDemangledType(program, this.getDataAddress(), rtti0Model, RTTI_2_NAME);
        }
        if (shouldCreateComment) {
            EHDataTypeUtilities.createPlateCommentIfNeeded(program, RttiUtil.getDescriptorTypeNamespace(rtti0Model) + "::", RTTI_2_NAME, null, this.getDataAddress(), this.applyOptions);
        }
        return true;
    }
}

