/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.SymbolPath;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMemberFunctionMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.CallingConvention;
import ghidra.app.util.pdb.pdbapplicator.AbstractComplexTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.AbstractFunctionTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.CompositeTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.MsTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.PdbApplicator;
import ghidra.app.util.pdb.pdbapplicator.PointerTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.PrimitiveTypeApplier;
import ghidra.util.exception.CancelledException;
import java.math.BigInteger;

public class MemberFunctionTypeApplier
extends AbstractFunctionTypeApplier {
    private MsTypeApplier thisPointerApplier = null;

    public MemberFunctionTypeApplier(PdbApplicator applicator, AbstractMemberFunctionMsType msType) throws IllegalArgumentException {
        super(applicator, msType);
    }

    @Override
    BigInteger getSize() {
        return BigInteger.ZERO;
    }

    @Override
    protected CallingConvention getCallingConvention() {
        return ((AbstractMemberFunctionMsType)this.msType).getCallingConvention();
    }

    @Override
    protected boolean hasThisPointer() {
        MsTypeApplier applier = this.applicator.getTypeApplier(((AbstractMemberFunctionMsType)this.msType).getThisPointerRecordNumber());
        return !(applier instanceof PrimitiveTypeApplier) || !((PrimitiveTypeApplier)applier).isNoType();
    }

    @Override
    protected RecordNumber getReturnRecordNumber() {
        return ((AbstractMemberFunctionMsType)this.msType).getReturnRecordNumber();
    }

    @Override
    protected RecordNumber getArgListRecordNumber() {
        return ((AbstractMemberFunctionMsType)this.msType).getArgListRecordNumber();
    }

    @Override
    protected boolean isConstructor() {
        return ((AbstractMemberFunctionMsType)this.msType).isConstructor();
    }

    @Override
    void apply() throws PdbException, CancelledException {
        this.predefineClasses();
        this.applyFunction(this.getCallingConvention(), this.hasThisPointer());
    }

    private void predefineClasses() throws CancelledException, PdbException {
        AbstractMemberFunctionMsType procType = (AbstractMemberFunctionMsType)this.msType;
        if (this.hasThisPointer()) {
            this.thisPointerApplier = this.getThisPointerApplier(procType);
            this.applicator.getPdbApplicatorMetrics().witnessMemberFunctionThisPointer(this.thisPointerApplier);
            if (this.thisPointerApplier instanceof PointerTypeApplier) {
                MsTypeApplier underlyingApplier = this.getThisUnderlyingApplier((PointerTypeApplier)this.thisPointerApplier);
                this.applicator.getPdbApplicatorMetrics().witnessMemberFunctionThisPointerUnderlyingType(underlyingApplier);
                if (underlyingApplier instanceof CompositeTypeApplier) {
                    this.predefineClass((CompositeTypeApplier)underlyingApplier);
                }
            }
        }
        AbstractComplexTypeApplier containingApplier = this.getContainingComplexApplier(procType);
        this.applicator.getPdbApplicatorMetrics().witnessMemberFunctionContainingType(containingApplier);
        if (containingApplier instanceof CompositeTypeApplier) {
            this.predefineClass((CompositeTypeApplier)containingApplier);
        }
    }

    private void predefineClass(CompositeTypeApplier applier) {
        SymbolPath containingClassSymbolPath = applier.getFixedSymbolPath();
        this.applicator.predefineClass(containingClassSymbolPath);
    }

    private MsTypeApplier getThisPointerApplier(AbstractMemberFunctionMsType procType) {
        MsTypeApplier applier = this.applicator.getTypeApplier(procType.getThisPointerRecordNumber());
        this.applicator.addApplierDependency(this, applier);
        return applier;
    }

    private MsTypeApplier getThisUnderlyingApplier(PointerTypeApplier thisApplier) {
        return thisApplier.getUnmodifiedUnderlyingTypeApplier();
    }

    private AbstractComplexTypeApplier getContainingComplexApplier(AbstractMemberFunctionMsType procType) throws PdbException {
        return AbstractComplexTypeApplier.getComplexApplier(this.applicator, procType.getContainingClassRecordNumber());
    }
}

