/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.type;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractParsableItem;
import ghidra.app.util.bin.format.pdb2.pdbreader.DelimiterState;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import java.util.HashMap;
import java.util.Map;

public class ClassFieldMsAttributes
extends AbstractParsableItem {
    private boolean compilerGenerateFunctionDoesNotExist;
    private boolean cannotBeInherited;
    private boolean cannotBeConstructed;
    private boolean compilerGenerateFunctionDoesExist;
    private boolean cannotBeOverridden;
    private Access access;
    private Property property;

    public ClassFieldMsAttributes(PdbByteReader reader) throws PdbException {
        int attributes = reader.parseUnsignedShortVal();
        this.processAttributes(attributes);
    }

    public Access getAccess() {
        return this.access;
    }

    public Property getProperty() {
        return this.property;
    }

    public boolean isCompilerGeneratedFunctionDoesExist() {
        return this.compilerGenerateFunctionDoesExist;
    }

    public boolean isCannotBeOverridden() {
        return this.cannotBeOverridden;
    }

    @Override
    public void emit(StringBuilder builder) {
        builder.append((Object)this.access);
        if (this.access != Access.BLANK && this.property != Property.BLANK) {
            builder.append(" ");
        }
        builder.append((Object)this.property);
        if (this.compilerGenerateFunctionDoesNotExist || this.cannotBeInherited || this.cannotBeConstructed) {
            DelimiterState ds = new DelimiterState("<", ", ");
            builder.append(ds.out(this.compilerGenerateFunctionDoesNotExist, "pseudo"));
            builder.append(ds.out(this.cannotBeInherited, "noinherit"));
            builder.append(ds.out(this.cannotBeConstructed, "noconstruct"));
            builder.append(">");
        }
    }

    private void processAttributes(int attributes) {
        this.access = Access.fromValue(attributes & 3);
        this.property = Property.fromValue((attributes >>= 2) & 7);
        this.compilerGenerateFunctionDoesNotExist = ((attributes >>= 3) & 1) == 1;
        this.cannotBeInherited = ((attributes >>= 1) & 1) == 1;
        this.cannotBeConstructed = ((attributes >>= 1) & 1) == 1;
        this.compilerGenerateFunctionDoesExist = ((attributes >>= 1) & 1) == 1;
        this.cannotBeOverridden = ((attributes >>= 1) & 1) == 1;
    }

    public static enum Property {
        INVALID("", -1),
        BLANK("", 0),
        VIRTUAL("virtual", 1),
        STATIC("static", 2),
        FRIEND("friend", 3),
        INTRO("<intro>", 4),
        PURE("<pure>", 5),
        INTRO_PURE("<intro,pure>", 6),
        RESERVED("", 7);

        private static final Map<Integer, Property> BY_VALUE;
        public final String label;
        public final int value;

        public void emit(StringBuilder builder) {
            builder.append(((Object)((Object)this)).getClass().getSimpleName());
        }

        public String toString() {
            return this.label;
        }

        public static Property fromValue(int val) {
            return BY_VALUE.getOrDefault(val, INVALID);
        }

        private Property(String label, int value) {
            this.label = label;
            this.value = value;
        }

        static {
            BY_VALUE = new HashMap<Integer, Property>();
            for (Property val : Property.values()) {
                BY_VALUE.put(val.value, val);
            }
        }
    }

    public static enum Access {
        INVALID("", -1),
        BLANK("", 0),
        PRIVATE("private", 1),
        PROTECTED("protected", 2),
        PUBLIC("public", 3);

        private static final Map<Integer, Access> BY_VALUE;
        public final String label;
        public final int value;

        public void emit(StringBuilder builder) {
            builder.append(((Object)((Object)this)).getClass().getSimpleName());
        }

        public String toString() {
            return this.label;
        }

        public static Access fromValue(int val) {
            return BY_VALUE.getOrDefault(val, INVALID);
        }

        private Access(String label, int value) {
            this.label = label;
            this.value = value;
        }

        static {
            BY_VALUE = new HashMap<Integer, Access>();
            for (Access val : Access.values()) {
                BY_VALUE.put(val.value, val);
            }
        }
    }
}

