/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.type;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordCategory;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.StringParseType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.ClassFieldMsAttributes;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.MsTypeField;

public abstract class AbstractOneMethodMsType
extends AbstractMsType
implements MsTypeField {
    protected ClassFieldMsAttributes attribute;
    protected RecordNumber procedureTypeRecordNumber;
    protected long offsetInVFTableIfIntroVirtual;
    protected String name;

    public AbstractOneMethodMsType(AbstractPdb pdb, PdbByteReader reader, int recordNumberSize, StringParseType strType) throws PdbException {
        super(pdb, reader);
        this.attribute = new ClassFieldMsAttributes(reader);
        this.procedureTypeRecordNumber = RecordNumber.parse(pdb, reader, RecordCategory.TYPE, recordNumberSize);
        this.offsetInVFTableIfIntroVirtual = this.attribute.getProperty() == ClassFieldMsAttributes.Property.INTRO || this.attribute.getProperty() == ClassFieldMsAttributes.Property.INTRO_PURE ? reader.parseUnsignedIntVal() : 0L;
        this.name = reader.parseString(pdb, strType);
        reader.skipPadding();
    }

    @Override
    public void emit(StringBuilder builder, AbstractMsType.Bind bind) {
        builder.append("<");
        builder.append(this.attribute);
        builder.append(": ");
        builder.append(this.pdb.getTypeRecord(this.procedureTypeRecordNumber));
        builder.append(",");
        builder.append(this.offsetInVFTableIfIntroVirtual);
        builder.append(">");
    }
}

