/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractModuleInformation;
import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.SymbolParser;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;

public class SymbolRecords {
    private AbstractPdb pdb;
    private Map<Long, AbstractMsSymbol> symbolsByOffset;
    private List<Map<Long, AbstractMsSymbol>> moduleSymbolsByOffset = new ArrayList<Map<Long, AbstractMsSymbol>>();

    public SymbolRecords(AbstractPdb pdb) {
        Objects.requireNonNull(pdb, "pdb cannot be null");
        this.pdb = pdb;
    }

    protected Map<Long, AbstractMsSymbol> getSymbolsByOffset() {
        return this.symbolsByOffset;
    }

    protected Map<Long, AbstractMsSymbol> getModuleSymbolsByOffset(int moduleNumber) {
        return this.moduleSymbolsByOffset.get(moduleNumber);
    }

    void deserialize(TaskMonitor monitor) throws IOException, PdbException, CancelledException {
        int streamNumber = this.pdb.getDebugInfo().getSymbolRecordsStreamNumber();
        PdbByteReader reader = this.pdb.getReaderForStreamNumber(streamNumber, monitor);
        this.symbolsByOffset = this.deserializeSymbolRecords(reader, monitor);
        for (AbstractModuleInformation module : this.pdb.getDebugInfo().moduleInformationList) {
            streamNumber = module.getStreamNumberDebugInformation();
            if (streamNumber != 65535) {
                reader = this.pdb.getReaderForStreamNumber(streamNumber, monitor);
                int x = reader.parseInt();
                int sizeDebug = module.getSizeLocalSymbolsDebugInformation();
                PdbByteReader debugReader = reader.getSubPdbByteReader(sizeDebug -= x);
                Map<Long, AbstractMsSymbol> oneModuleSymbolsByOffset = this.deserializeSymbolRecords(debugReader, monitor);
                this.moduleSymbolsByOffset.add(oneModuleSymbolsByOffset);
                continue;
            }
            this.moduleSymbolsByOffset.add(new TreeMap());
        }
    }

    public Map<Long, AbstractMsSymbol> deserializeSymbolRecords(PdbByteReader reader, TaskMonitor monitor) throws PdbException, CancelledException {
        SymbolParser parser = this.pdb.getSymbolParser();
        TreeMap<Long, AbstractMsSymbol> mySymbolsByOffset = new TreeMap<Long, AbstractMsSymbol>();
        while (reader.hasMore()) {
            monitor.checkCanceled();
            int offset = reader.getIndex();
            int recordLength = reader.parseUnsignedShortVal();
            PdbByteReader recordReader = reader.getSubPdbByteReader(recordLength);
            recordReader.markAlign(2);
            AbstractMsSymbol symbol = parser.parse(recordReader);
            mySymbolsByOffset.put(Long.valueOf(offset), symbol);
        }
        return mySymbolsByOffset;
    }

    protected void dump(Writer writer) throws IOException {
        writer.write("SymbolRecords-----------------------------------------------\n");
        this.dumpSymbolMap(this.symbolsByOffset, writer);
        for (int i = 0; i < this.moduleSymbolsByOffset.size(); ++i) {
            Map<Long, AbstractMsSymbol> map = this.moduleSymbolsByOffset.get(i);
            if (map == null) continue;
            writer.write("Module(" + i + ") List:\n");
            this.dumpSymbolMap(map, writer);
        }
        writer.write("\nEnd SymbolRecords-------------------------------------------\n");
    }

    protected void dumpSymbolMap(Map<Long, AbstractMsSymbol> mySymbolsByOffset, Writer writer) throws IOException {
        writer.write("SymbolMap---------------------------------------------------");
        for (Map.Entry<Long, AbstractMsSymbol> entry : mySymbolsByOffset.entrySet()) {
            StringBuilder builder = new StringBuilder();
            builder.append("\n------------------------------------------------------------\n");
            builder.append(String.format("Offset: 0X%08X\n", entry.getKey()));
            builder.append(entry.getValue());
            writer.write(builder.toString());
        }
        writer.write("\nEnd SymbolMap-----------------------------------------------\n");
    }
}

