/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api.stringable.deprecated;

import ghidra.program.model.data.DataType;
import ghidra.program.model.data.ProgramBasedDataTypeManager;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.ParameterImpl;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.InvalidInputException;
import java.util.StringTokenizer;

public class ParameterInfo
extends ParameterImpl {
    static ParameterInfo createParameterInfo(Parameter param) {
        try {
            ParameterInfo paramInfo = new ParameterInfo(param.getName(), param.getOrdinal(), param.getDataType(), param.getVariableStorage(), param.getProgram(), param.getSource());
            paramInfo.setComment(param.getComment());
            return paramInfo;
        }
        catch (InvalidInputException e) {
            throw new AssertException("Failed to clone parameter: " + param.getFunction().getName() + ":" + param.getName());
        }
    }

    static ParameterInfo createParameterInfo(String localVariableInfoString, Program program) {
        try {
            StringTokenizer tokenizer = new StringTokenizer(localVariableInfoString, "\t");
            tokenizer.nextToken();
            long managerUniversalID = Long.parseLong(tokenizer.nextToken());
            long dataTypeID = Long.parseLong(tokenizer.nextToken());
            String dataTypeName = tokenizer.nextToken();
            DataType dt = ParameterInfo.getDataType(program, managerUniversalID, dataTypeID);
            if (dt == null || !dt.getName().equals(dataTypeName)) {
                throw new AssertException("Data type name/ID mismatch " + dt.getName() + " doesn't match " + dataTypeName + ".");
            }
            int ordinal = Integer.parseInt(tokenizer.nextToken());
            String localVariableName = tokenizer.nextToken();
            SourceType sourceType = SourceType.valueOf((String)tokenizer.nextToken());
            String comment = tokenizer.nextToken();
            VariableStorage storage = VariableStorage.deserialize((Program)program, (String)tokenizer.nextToken());
            ParameterInfo paramInfo = new ParameterInfo(localVariableName, ordinal, dt, storage, program, sourceType);
            paramInfo.setComment(comment);
            return paramInfo;
        }
        catch (Exception e) {
            throw new AssertException("Failed to deserialize local variable (" + localVariableInfoString + "): " + e.getMessage());
        }
    }

    private static DataType getDataType(Program program, long managerUniversalID, long dataTypeID) {
        ProgramBasedDataTypeManager dataTypeManager = program.getDataTypeManager();
        long actualUniversalID = dataTypeManager.getUniversalID().getValue();
        if (actualUniversalID != managerUniversalID) {
            throw new AssertException("Provided data type manager ID of " + actualUniversalID + " doesn't matched saved ID of " + managerUniversalID + ".");
        }
        return dataTypeManager.getDataType(dataTypeID);
    }

    ParameterInfo(String name, int firstUseOffset, DataType dataType, VariableStorage storage, Program program, SourceType sourceType) throws InvalidInputException {
        super(name, firstUseOffset, dataType, storage, true, program, sourceType);
    }

    String convertToString() {
        ProgramBasedDataTypeManager dataTypeMananger = this.getProgram().getDataTypeManager();
        DataType dt = this.getDataType();
        StringBuffer buffy = new StringBuffer();
        buffy.append(((Object)((Object)this)).getClass().getSimpleName()).append("\t");
        buffy.append(Long.toString(dataTypeMananger.getUniversalID().getValue())).append("\t");
        buffy.append(Long.toString(dataTypeMananger.getID(dt))).append("\t");
        buffy.append(dt.getName()).append("\t");
        buffy.append(Integer.toString(this.getOrdinal())).append("\t");
        buffy.append(this.getName()).append("\t");
        buffy.append(this.getSource().name()).append("\t");
        buffy.append(this.getComment()).append("\t");
        buffy.append(this.getVariableStorage().getSerializationString());
        return buffy.toString();
    }

    public Parameter createParameterDefinition(Function destFunction, int ordinal) {
        try {
            MyParameter var = new MyParameter(this.getName(), this.getOrdinal(), this.getDataType(), this.getVariableStorage().getSerializationString(), destFunction.getProgram(), this.getSource());
            var.setComment(this.getComment());
            return var;
        }
        catch (InvalidInputException e) {
            Msg.error((Object)((Object)this), (Object)("Unable to apply parameter '" + this.getName() + "' to function " + destFunction.getName() + ": " + e.getMessage()));
            return null;
        }
    }

    private static class MyParameter
    extends ParameterImpl {
        MyParameter(String name, int ordinal, DataType dataType, String serializedStorage, Program program, SourceType sourceType) throws InvalidInputException {
            super(name, ordinal, dataType, VariableStorage.deserialize((Program)program, (String)serializedStorage), true, program, sourceType);
        }
    }
}

