/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.fieldpanel.field;

import docking.widgets.fieldpanel.field.Field;
import docking.widgets.fieldpanel.internal.FieldBackgroundColorManager;
import docking.widgets.fieldpanel.internal.PaintContext;
import docking.widgets.fieldpanel.support.DefaultRowColLocation;
import docking.widgets.fieldpanel.support.RowColLocation;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;

public class EmptyTextField
implements Field {
    protected int startX;
    protected int width;
    protected int heightAbove;
    protected int height;
    protected boolean isPrimary;

    public EmptyTextField(int heightAbove, int heightBelow, int startX, int width) {
        this.startX = startX;
        this.width = width;
        this.height = heightAbove + heightBelow;
        this.heightAbove = heightAbove;
    }

    public boolean isAllowCursorAtEnd() {
        return false;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getPreferredWidth() {
        return 0;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getStartX() {
        return this.startX;
    }

    @Override
    public int getNumDataRows() {
        return 1;
    }

    @Override
    public int getNumRows() {
        return 1;
    }

    @Override
    public int getNumCols(int row) {
        return 0;
    }

    @Override
    public int getRow(int y) {
        return 0;
    }

    @Override
    public int getCol(int row, int x) {
        return 0;
    }

    @Override
    public int getY(int row) {
        return -this.heightAbove;
    }

    @Override
    public int getX(int row, int col) {
        return 0;
    }

    @Override
    public boolean isValid(int row, int col) {
        if (row != 0) {
            return false;
        }
        return col == 0;
    }

    @Override
    public void paint(JComponent c, Graphics g, PaintContext context, Rectangle clip, FieldBackgroundColorManager map, RowColLocation cursorLoc, int rowHeight) {
        this.paintCursor(g, context.getCursorColor(), cursorLoc);
    }

    private void paintCursor(Graphics g, Color cursorColor, RowColLocation cursorLoc) {
        if (cursorLoc != null) {
            g.setColor(cursorColor);
            if (cursorLoc.col() == 0) {
                int x = this.startX;
                g.fillRect(x, -this.heightAbove, 2, this.height);
            }
        }
    }

    @Override
    public Rectangle getCursorBounds(int row, int col) {
        if (row != 0) {
            return null;
        }
        int x = this.startX;
        return new Rectangle(x, -this.heightAbove, 2, this.height);
    }

    @Override
    public boolean contains(int x, int y) {
        return x >= this.startX && x < this.startX + this.width && y >= -this.heightAbove && y < this.height - this.heightAbove;
    }

    public void setForeground(Color color) {
    }

    public Color getForeground() {
        return Color.WHITE;
    }

    @Override
    public int getScrollableUnitIncrement(int topOfScreen, int direction, int max) {
        if (topOfScreen < -this.heightAbove || topOfScreen > this.height - this.heightAbove) {
            return max;
        }
        if (direction > 0) {
            return this.height - topOfScreen - this.heightAbove;
        }
        return this.heightAbove - topOfScreen;
    }

    @Override
    public boolean isPrimary() {
        return this.isPrimary;
    }

    public void setPrimary(boolean state) {
        this.isPrimary = state;
    }

    @Override
    public int getHeightAbove() {
        return this.heightAbove;
    }

    @Override
    public int getHeightBelow() {
        return this.height - this.heightAbove;
    }

    @Override
    public void rowHeightChanged(int newHeightAbove, int newHeightBelow) {
    }

    @Override
    public String getText() {
        return "";
    }

    @Override
    public String getTextWithLineSeparators() {
        return "";
    }

    @Override
    public RowColLocation textOffsetToScreenLocation(int textOffset) {
        return new DefaultRowColLocation();
    }

    @Override
    public int screenLocationToTextOffset(int row, int col) {
        return 0;
    }
}

