/*
 * Decompiled with CFR 0.152.
 */
package docking.menu;

import docking.action.DockingActionIf;
import ghidra.docking.util.DockingWindowsLookAndFeelUtils;
import ghidra.util.StringUtilities;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.KeyStroke;
import org.apache.commons.lang3.StringUtils;

class DockingToolBarUtils {
    private static final String START_KEYBINDING_TEXT = "<BR><HR><CENTER>(";
    private static final String END_KEYBINDNIG_TEXT = ")</CENTER>";

    DockingToolBarUtils() {
    }

    static void setToolTipText(JButton button, DockingActionIf action) {
        String toolTipText = DockingToolBarUtils.getToolTipText(action);
        String keyBindingText = DockingToolBarUtils.getKeyBindingAcceleratorText(button, action.getKeyBinding());
        if (keyBindingText != null) {
            button.setToolTipText(DockingToolBarUtils.combingToolTipTextWithKeyBinding(toolTipText, keyBindingText));
        } else {
            button.setToolTipText(toolTipText);
        }
    }

    private static String combingToolTipTextWithKeyBinding(String toolTipText, String keyBindingText) {
        StringBuilder buffy = new StringBuilder(toolTipText);
        if (StringUtilities.startsWithIgnoreCase((String)toolTipText, (String)"<HTML>")) {
            String endHTMLTag = "</HTML>";
            int closeTagIndex = StringUtils.indexOfIgnoreCase((CharSequence)toolTipText, (CharSequence)endHTMLTag);
            if (closeTagIndex < 0) {
                buffy.append(START_KEYBINDING_TEXT).append(keyBindingText).append(END_KEYBINDNIG_TEXT);
            } else {
                buffy.delete(closeTagIndex, closeTagIndex + endHTMLTag.length() + 1);
                buffy.append(START_KEYBINDING_TEXT).append(keyBindingText).append(END_KEYBINDNIG_TEXT).append(endHTMLTag);
            }
            return buffy.toString();
        }
        return toolTipText + " (" + keyBindingText + ")";
    }

    private static String getToolTipText(DockingActionIf action) {
        String description = action.getDescription();
        if (!StringUtils.isEmpty((CharSequence)description)) {
            return description;
        }
        return action.getName();
    }

    private static String getKeyBindingAcceleratorText(JButton button, KeyStroke keyStroke) {
        int keyCode;
        if (keyStroke == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        int modifiers = keyStroke.getModifiers();
        if (modifiers > 0) {
            builder.append(InputEvent.getModifiersExText(modifiers));
            if (!DockingWindowsLookAndFeelUtils.isUsingAquaUI(button.getUI())) {
                builder.append('+');
            }
        }
        if ((keyCode = keyStroke.getKeyCode()) != 0) {
            builder.append(KeyEvent.getKeyText(keyCode));
        } else {
            builder.append(keyStroke.getKeyChar());
        }
        return builder.toString();
    }
}

