/*
 * Decompiled with CFR 0.152.
 */
package docking.help;

import docking.framework.ApplicationInformationDisplayFactory;
import docking.help.CustomTOCView;
import docking.help.GHelpHTMLEditorKit;
import docking.help.HelpViewSearcher;
import docking.help.ToggleNavigationAid;
import docking.util.AnimationPainter;
import docking.util.AnimationUtils;
import ghidra.framework.preferences.Preferences;
import ghidra.util.Msg;
import ghidra.util.bean.GGlassPane;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Window;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.help.DefaultHelpBroker;
import javax.help.HelpModel;
import javax.help.HelpSet;
import javax.help.JHelp;
import javax.help.JHelpContentViewer;
import javax.help.NavigatorView;
import javax.help.WindowPresentation;
import javax.help.event.HelpModelEvent;
import javax.help.event.HelpModelListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import org.jdesktop.animation.timing.Animator;
import org.jdesktop.animation.timing.TimingTarget;
import org.jdesktop.animation.timing.TimingTargetAdapter;
import resources.ResourceManager;

public class GHelpBroker
extends DefaultHelpBroker {
    private static final List<Image> ICONS = ApplicationInformationDisplayFactory.getWindowIcons();
    private static final int MAX_CALLOUT_RETRIES = 3;
    private Dimension windowSize = new Dimension(1100, 700);
    private JEditorPane htmlEditorPane;
    private Animator lastAnimator;
    private URL loadingURL;
    private PropertyChangeListener pageLoadListener = new PageLoadingListener();
    private HelpModelListener helpModelListener = new HelpIDChangedListener();
    private Window activationWindow;
    private static final ImageIcon ZOOM_OUT_ICON = ResourceManager.loadImage((String)"images/list-remove.png");
    private static final ImageIcon ZOOM_IN_ICON = ResourceManager.loadImage((String)"images/list-add.png");

    public GHelpBroker(HelpSet hs) {
        super(hs);
    }

    public void setCurrentURL(URL URL2) {
        HelpModel model = this.getHelpModel();
        if (model != null) {
            model.setCurrentURL(URL2, this.getHistoryName(URL2), null);
        } else {
            super.setCurrentURL(URL2);
        }
    }

    void reloadHelpPage(URL url) {
        this.clearContentViewer();
        this.prepareToCallout(url);
        try {
            this.htmlEditorPane.setPage(url);
        }
        catch (IOException e) {
            Msg.error((Object)((Object)this), (Object)("Unexpected error loading help page: " + url), (Throwable)e);
        }
    }

    private void clearContentViewer() {
        this.htmlEditorPane.getDocument().putProperty("stream", null);
    }

    private JScrollPane getScrollPane(JEditorPane editorPane) {
        for (Container parent = editorPane.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof JScrollPane)) continue;
            return (JScrollPane)parent;
        }
        return null;
    }

    private JEditorPane getHTMLEditorPane(JHelpContentViewer contentViewer) {
        Component[] components = contentViewer.getComponents();
        JScrollPane scrollPane = (JScrollPane)components[0];
        JViewport viewport = scrollPane.getViewport();
        return (JEditorPane)viewport.getView();
    }

    private HelpModel getHelpModel() {
        WindowPresentation windowPresentation = this.getWindowPresentation();
        HelpSet helpSet = windowPresentation.getHelpSet();
        NavigatorView tocView = helpSet.getNavigatorView("TOC");
        if (!(tocView instanceof CustomTOCView)) {
            Msg.debug((Object)((Object)this), (Object)"The help system is not using the CustomTOCView class!");
            return null;
        }
        CustomTOCView customTOCView = (CustomTOCView)tocView;
        return customTOCView.getHelpModel();
    }

    public void setDisplayed(boolean b) {
        if (!b) {
            super.setDisplayed(b);
            return;
        }
        this.initializeScreenDevice();
        WindowPresentation windowPresentation = this.getWindowPresentation();
        this.updateWindowSize(windowPresentation);
        super.setDisplayed(b);
        this.initializeUIWindowPresentation(windowPresentation);
    }

    private void initializeScreenDevice() {
        if (this.isInitialized()) {
            return;
        }
        if (this.activationWindow == null) {
            return;
        }
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gs = ge.getScreenDevices();
        GraphicsConfiguration config = this.activationWindow.getGraphicsConfiguration();
        GraphicsDevice parentDevice = config.getDevice();
        for (int i = 0; i < gs.length; ++i) {
            if (gs[i] != parentDevice) continue;
            this.setScreen(i);
        }
    }

    private void initializeUIWindowPresentation(WindowPresentation windowPresentation) {
        Window helpWindow = windowPresentation.getHelpWindow();
        Container contentPane = null;
        if (helpWindow instanceof JFrame) {
            JFrame frame = (JFrame)helpWindow;
            this.installRootPane(frame);
            frame.setIconImages(ICONS);
            contentPane = frame.getContentPane();
        } else if (helpWindow instanceof JDialog) {
            JDialog dialog = (JDialog)helpWindow;
            this.installRootPane(dialog);
            contentPane = dialog.getContentPane();
        }
        this.initializeUIComponents(contentPane);
    }

    private boolean isInitialized() {
        return this.htmlEditorPane != null;
    }

    private void initializeUIComponents(Container contentPane) {
        if (this.isInitialized()) {
            return;
        }
        Component[] components = contentPane.getComponents();
        JHelp jHelp = (JHelp)components[0];
        this.addCustomToolbarItems(jHelp);
        JHelpContentViewer contentViewer = jHelp.getContentViewer();
        this.htmlEditorPane = this.getHTMLEditorPane(contentViewer);
        HelpModel helpModel = this.getHelpModel();
        helpModel.addHelpModelListener(this.helpModelListener);
        new HelpViewSearcher(jHelp, helpModel);
        this.installActions(jHelp);
    }

    protected void addCustomToolbarItems(JHelp jHelp) {
        for (Component component : jHelp.getComponents()) {
            if (!(component instanceof JToolBar)) continue;
            JToolBar toolbar = (JToolBar)component;
            toolbar.addSeparator();
            ImageIcon zoomOutIcon = ResourceManager.getScaledIcon((Icon)ZOOM_OUT_ICON, (int)24, (int)24);
            JButton zoomOutBtn = new JButton(zoomOutIcon);
            zoomOutBtn.setToolTipText("Zoom out");
            zoomOutBtn.addActionListener(e -> {
                GHelpHTMLEditorKit.zoomOut();
                this.reloadHelpPage(this.getCurrentURL());
            });
            toolbar.add(zoomOutBtn);
            ImageIcon zoomInIcon = ResourceManager.getScaledIcon((Icon)ZOOM_IN_ICON, (int)24, (int)24);
            JButton zoomInBtn = new JButton(zoomInIcon);
            zoomInBtn.setToolTipText("Zoom in");
            zoomInBtn.addActionListener(e -> {
                GHelpHTMLEditorKit.zoomIn();
                this.reloadHelpPage(this.getCurrentURL());
            });
            toolbar.add(zoomInBtn);
            break;
        }
    }

    private void installActions(JHelp help) {
        Component[] components;
        JToolBar toolbar = null;
        for (Component c : components = help.getComponents()) {
            if (!(c instanceof JToolBar)) continue;
            toolbar = (JToolBar)c;
            break;
        }
        if (toolbar == null) {
            return;
        }
        toolbar.addSeparator();
        ToggleNavigationAid action = new ToggleNavigationAid();
        toolbar.add(new JButton(action));
    }

    private String getHistoryName(URL URL2) {
        String ref;
        Object text = URL2.getFile();
        int index = ((String)text).lastIndexOf(47);
        if (index != -1) {
            text = ((String)text).substring(index + 1);
        }
        if ((ref = URL2.getRef()) != null) {
            text = (String)text + " - " + ref;
        }
        return text;
    }

    private void installRootPane(JFrame frame) {
        Component oldGlassPane = frame.getGlassPane();
        if (!(oldGlassPane instanceof GGlassPane)) {
            GGlassPane gGlassPane = new GGlassPane();
            frame.setGlassPane((Component)gGlassPane);
            gGlassPane.setVisible(true);
        }
    }

    private void installRootPane(JDialog dialog) {
        Component oldGlassPane = dialog.getGlassPane();
        if (!(oldGlassPane instanceof GGlassPane)) {
            GGlassPane gGlassPane = new GGlassPane();
            dialog.setGlassPane((Component)gGlassPane);
            gGlassPane.setVisible(true);
        }
    }

    private void updateWindowSize(WindowPresentation presentation) {
        if (this.windowSize == null) {
            return;
        }
        presentation.createHelpWindow();
        presentation.setSize(this.windowSize);
    }

    public void setActivationWindow(Window window) {
        WindowPresentation windowPresentation = this.getWindowPresentation();
        Window helpWindow = windowPresentation.getHelpWindow();
        if (helpWindow == null) {
            this.activationWindow = window;
            super.setActivationWindow(window);
            return;
        }
        this.windowSize = helpWindow.getSize();
        boolean wasModal = this.isModalWindow(helpWindow);
        boolean willBeModal = this.isModalWindow(window);
        if (!wasModal && willBeModal) {
            helpWindow.setVisible(false);
        }
        super.setActivationWindow(window);
    }

    private boolean isModalWindow(Window window) {
        Dialog dialog;
        return window instanceof Dialog && (dialog = (Dialog)window).isModal();
    }

    private void showNavigationAid() {
        String showAidString = Preferences.getProperty((String)"SHOW.HELP.NAVIGATION.AID");
        if (showAidString == null) {
            return;
        }
        boolean showAid = Boolean.parseBoolean(showAidString);
        if (!showAid) {
            return;
        }
        this.calloutReferenceLater();
    }

    private void calloutReferenceLater() {
        SwingUtilities.invokeLater(() -> this.calloutReference(this.loadingURL));
    }

    private void calloutReference(URL url) {
        String ref = url.getRef();
        if (ref == null) {
            return;
        }
        Rectangle area = this.getReferenceArea(ref);
        if (area == null) {
            return;
        }
        this.doCalloutReference(area, 0);
    }

    private Rectangle getReferenceArea(String ref) {
        HTMLDocument document = (HTMLDocument)this.htmlEditorPane.getDocument();
        HTMLDocument.Iterator iter = document.getIterator(HTML.Tag.A);
        while (iter.isValid()) {
            AttributeSet attributes = iter.getAttributes();
            String name = (String)attributes.getAttribute(HTML.Attribute.NAME);
            if (name != null && name.equals(ref)) {
                try {
                    int start = iter.getStartOffset();
                    Rectangle2D startArea = this.htmlEditorPane.modelToView2D(start);
                    return startArea.getBounds();
                }
                catch (BadLocationException ble) {
                    Msg.trace((Object)((Object)this), (Object)"Unexpected exception searching for help reference", (Throwable)ble);
                }
            }
            iter.next();
        }
        return null;
    }

    private void doCalloutReference(Rectangle area, int callCount) {
        if (callCount > 3) {
            return;
        }
        WindowPresentation windowPresentation = this.getWindowPresentation();
        Window helpWindow = windowPresentation.getHelpWindow();
        Container contentPane = null;
        contentPane = helpWindow instanceof JDialog ? ((JDialog)helpWindow).getContentPane() : ((JFrame)helpWindow).getContentPane();
        JScrollPane scrollPane = this.getScrollPane(this.htmlEditorPane);
        JViewport viewport = scrollPane.getViewport();
        Point viewPosition = viewport.getViewPosition();
        int numberOfCalls = callCount + 1;
        if (viewPosition.x == 0 && viewPosition.y == 0) {
            SwingUtilities.invokeLater(() -> this.doCalloutReference(area, numberOfCalls));
            return;
        }
        area.y -= viewPosition.y;
        Rectangle relativeArea = SwingUtilities.convertRectangle(scrollPane, area, contentPane);
        StarShape star = new StarShape(relativeArea.getLocation());
        Animator animator = AnimationUtils.createPaintingAnimator(helpWindow, new LocationHintPainter(star));
        if (animator == null) {
            return;
        }
        this.lastAnimator = animator;
        this.lastAnimator.addTarget((TimingTarget)new TimingTargetAdapter(){

            public void end() {
                GHelpBroker.this.lastAnimator = null;
            }
        });
    }

    private void prepareToCallout(URL url) {
        if (this.lastAnimator != null) {
            this.lastAnimator.stop();
        }
        this.loadingURL = url;
        if (this.isCurrentPage(this.loadingURL)) {
            this.showNavigationAid();
            return;
        }
        this.htmlEditorPane.removePropertyChangeListener("page", this.pageLoadListener);
        this.htmlEditorPane.addPropertyChangeListener("page", this.pageLoadListener);
    }

    private boolean isCurrentPage(URL newURL) {
        if (newURL == null) {
            return false;
        }
        String newFile = newURL.getFile();
        URL currentURL = this.htmlEditorPane.getPage();
        if (currentURL == null) {
            return false;
        }
        String currentFile = currentURL.getFile();
        return newFile.equals(currentFile);
    }

    private class LocationHintPainter
    implements AnimationPainter {
        private Color color = new Color(100, 100, 255, 100);
        private Shape paintShape;

        LocationHintPainter(Shape paintShape) {
            this.paintShape = paintShape;
        }

        @Override
        public void paint(GGlassPane glassPane, Graphics graphics, double percentComplete) {
            Graphics2D g2d = (Graphics2D)graphics;
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            Composite originalComposite = g2d.getComposite();
            AlphaComposite alphaComposite = AlphaComposite.getInstance(AlphaComposite.SrcOver.getRule(), (float)(1.0 - percentComplete));
            g2d.setComposite(alphaComposite);
            double transition = 1.0 - percentComplete;
            Color originalColor = g2d.getColor();
            AffineTransform originalTransform = g2d.getTransform();
            double scale = 4.0 * transition;
            int degrees = (int)(480.0 * transition);
            double rad = Math.toRadians(transition * (double)degrees);
            Rectangle b = this.paintShape.getBounds();
            double cx = b.getCenterX();
            double cy = b.getCenterY();
            double scx = cx * scale;
            double scy = cy * scale;
            double dcx = scx - cx;
            double dcy = scy - cy;
            AffineTransform scaler = new AffineTransform();
            scaler.translate(-dcx, -dcy);
            scaler.scale(scale, scale);
            Shape scaled = scaler.createTransformedShape(this.paintShape);
            AffineTransform rotater = new AffineTransform();
            rotater.rotate(rad, cx, cy);
            Shape finalShape = rotater.createTransformedShape(scaled);
            g2d.setColor(this.color);
            g2d.fill(finalShape);
            g2d.setColor(originalColor);
            g2d.setTransform(originalTransform);
            g2d.setComposite(originalComposite);
        }
    }

    private class HelpIDChangedListener
    implements HelpModelListener {
        private HelpIDChangedListener() {
        }

        public void idChanged(HelpModelEvent e) {
            GHelpBroker.this.prepareToCallout(e.getURL());
        }
    }

    private class PageLoadingListener
    implements PropertyChangeListener {
        private PageLoadingListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            GHelpBroker.this.showNavigationAid();
            GHelpBroker.this.htmlEditorPane.removePropertyChangeListener("page", GHelpBroker.this.pageLoadListener);
        }
    }

    private class StarShape
    extends Path2D.Float {
        StarShape(Point location) {
            this(5, location, 1.0, 0.3);
        }

        StarShape(int points, Point location, double outerRadius, double innerRadius) {
            int width;
            double angle = Math.PI / (double)points;
            GeneralPath path = new GeneralPath();
            int scale = 20;
            double lr = Math.max(outerRadius, innerRadius);
            int height = width = (int)((double)scale * (2.0 * lr));
            double cx = location.x + width / 2;
            double cy = location.y + height / 2;
            Point2D.Double center = new Point2D.Double(cx, cy);
            double r = outerRadius;
            double x = center.x + Math.cos(0.0 * angle) * r;
            double y = center.y + Math.sin(0.0 * angle) * r;
            path.moveTo(x, y);
            for (int i = 1; i < 2 * points; ++i) {
                r = i % 2 == 0 ? outerRadius : innerRadius;
                x = center.x + Math.cos((double)i * angle) * r;
                y = center.y + Math.sin((double)i * angle) * r;
                path.lineTo(x, y);
            }
            path.closePath();
            double scx = (double)scale * cx;
            double scy = (double)scale * cy;
            double offsetx = width / 4;
            double offsety = height / 4;
            double sox = scx - offsetx;
            double soy = scy - offsety;
            double dx = sox - (double)location.x;
            double dy = soy - (double)location.y;
            AffineTransform xform = AffineTransform.getTranslateInstance(-dx, -dy);
            xform.scale(scale, scale);
            Shape shape = xform.createTransformedShape(path);
            super.append(shape, true);
        }
    }
}

