/*
 * Decompiled with CFR 0.152.
 */
package docking;

import docking.ActionContext;
import docking.ComponentPlaceholder;
import docking.ComponentProvider;
import docking.DockingWindowManager;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.KeyBindingData;
import docking.action.KeyBindingType;
import docking.action.MenuData;
import docking.actions.AutoGeneratedDockingAction;
import ghidra.util.HelpLocation;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import resources.ResourceManager;

class ShowComponentAction
extends DockingAction
implements AutoGeneratedDockingAction,
Comparable<ShowComponentAction> {
    private static final int MAX_LENGTH = 40;
    protected static final ImageIcon EMPTY_ICON = ResourceManager.loadImage((String)"images/EmptyIcon16.gif");
    protected static final String MENU_WINDOW = "&Window";
    protected DockingWindowManager winMgr;
    private ComponentPlaceholder info;
    private String title;

    private static String truncateTitleAsNeeded(String title) {
        if (title.length() <= 40) {
            return title;
        }
        return title.substring(0, 37) + "...";
    }

    protected ShowComponentAction(DockingWindowManager winMgr, String name, String subMenuName) {
        super(ShowComponentAction.truncateTitleAsNeeded(name), "DockingWindows");
        this.winMgr = winMgr;
    }

    ShowComponentAction(DockingWindowManager winMgr, ComponentPlaceholder placeholder, String subMenuName, boolean isTransient) {
        super(placeholder.getProvider().getName(), "DockingWindows", ShowComponentAction.createKeyBindingType(isTransient, placeholder));
        this.info = placeholder;
        this.winMgr = winMgr;
        this.title = ShowComponentAction.truncateTitleAsNeeded(placeholder.getTitle());
        Icon icon = placeholder.getIcon();
        if (icon == null) {
            icon = EMPTY_ICON;
        }
        if (subMenuName != null) {
            this.setMenuBarData(new MenuData(new String[]{MENU_WINDOW, subMenuName, placeholder.getFullTitle()}, icon, "Permanent"));
        } else {
            this.setMenuBarData(new MenuData(new String[]{MENU_WINDOW, this.title}, icon, "Permanent"));
        }
        ComponentProvider provider = placeholder.getProvider();
        this.synchronizeKeyBinding(provider);
        HelpLocation helpLocation = provider.getHelpLocation();
        if (helpLocation != null) {
            this.setHelpLocation(helpLocation);
        } else {
            this.markHelpUnnecessary();
        }
    }

    private void synchronizeKeyBinding(ComponentProvider provider) {
        if (!this.getKeyBindingType().supportsKeyBindings()) {
            return;
        }
        DockingActionIf action = provider.getShowProviderAction();
        KeyBindingData defaultBinding = action.getDefaultKeyBindingData();
        this.setKeyBindingData(defaultBinding);
        KeyBindingData kbData = action.getKeyBindingData();
        if (kbData != null) {
            this.setUnvalidatedKeyBindingData(kbData);
        }
    }

    private static KeyBindingType createKeyBindingType(boolean isTransient, ComponentPlaceholder placeholder) {
        if (isTransient) {
            return KeyBindingType.UNSUPPORTED;
        }
        return placeholder == null ? KeyBindingType.UNSUPPORTED : KeyBindingType.SHARED;
    }

    @Override
    public void actionPerformed(ActionContext context) {
        this.winMgr.showComponent(this.info, true, true, true);
    }

    @Override
    public boolean isEnabledForContext(ActionContext context) {
        return true;
    }

    @Override
    public int compareTo(ShowComponentAction other) {
        String[] myMenuPath = this.getMenuBarData().getMenuPath();
        String[] otherMenuPath = other.getMenuBarData().getMenuPath();
        int loopLength = Math.min(myMenuPath.length, otherMenuPath.length);
        for (int i = 0; i < loopLength; ++i) {
            int result = myMenuPath[i].compareTo(otherMenuPath[i]);
            if (result == 0) continue;
            return result;
        }
        return myMenuPath.length - otherMenuPath.length;
    }

    @Override
    public String getHelpInfo() {
        if (this.info == null) {
            return super.getHelpInfo();
        }
        StringBuilder buffy = new StringBuilder(super.getHelpInfo());
        ComponentProvider provider = this.info.getProvider();
        Class<?> clazz = provider.getClass();
        String className = clazz.getName();
        String filename = className.substring(className.lastIndexOf(46) + 1);
        DockingActionIf showAction = provider.getShowProviderAction();
        String realInception = showAction.getInceptionInformation();
        buffy.append("           ").append(realInception).append("\n    ");
        buffy.append("    ").append("PROVIDER:    ").append(filename).append(' ');
        buffy.append('(').append(provider.getOwner()).append(")");
        buffy.append("\n    ");
        return buffy.toString();
    }
}

