/*
 * Decompiled with CFR 0.152.
 */
package docking;

import docking.DefaultFocusOwnerProvider;
import docking.DockingDialog;
import docking.DockingKeyBindingAction;
import docking.DockingWindowManager;
import docking.FocusOwnerProvider;
import docking.KeyBindingPrecedence;
import docking.action.MultipleKeyAction;
import docking.actions.KeyBindingUtils;
import docking.menu.keys.MenuKeyProcessor;
import ghidra.util.bean.GGlassPane;
import ghidra.util.exception.AssertException;
import java.awt.Component;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

public class KeyBindingOverrideKeyEventDispatcher
implements KeyEventDispatcher {
    private static KeyBindingOverrideKeyEventDispatcher instance = null;
    private DockingKeyBindingAction inProgressAction;
    private FocusOwnerProvider focusProvider = new DefaultFocusOwnerProvider();

    static void install() {
        if (instance == null) {
            instance = new KeyBindingOverrideKeyEventDispatcher();
            KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            kfm.addKeyEventDispatcher(instance);
        }
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent event) {
        if (this.blockKeyInput(event)) {
            return true;
        }
        if (this.actionInProgress(event)) {
            return true;
        }
        if (MenuKeyProcessor.processMenuKeyEvent(event)) {
            return true;
        }
        DockingKeyBindingAction action = this.getDockingKeyBindingActionForEvent(event);
        if (action == null) {
            return false;
        }
        if (this.processReservedKeyActionsPrecedence(action, event)) {
            return true;
        }
        KeyStroke ks = KeyStroke.getKeyStrokeForEvent(event);
        if (!this.isValidContextForKeyStroke(ks)) {
            return false;
        }
        if (this.willBeHandledByTextComponent(event)) {
            return false;
        }
        KeyBindingPrecedence keyBindingPrecedence = this.getValidKeyBindingPrecedence(action);
        if (keyBindingPrecedence == null) {
            return false;
        }
        return this.processKeyListenerPrecedence(action, keyBindingPrecedence, event) || this.processComponentActionMapPrecedence(action, keyBindingPrecedence, event) || this.processActionAtPrecedence(KeyBindingPrecedence.DefaultLevel, keyBindingPrecedence, action, event) || this.throwAssertException();
    }

    private KeyBindingPrecedence getValidKeyBindingPrecedence(DockingKeyBindingAction action) {
        if (action instanceof MultipleKeyAction) {
            MultipleKeyAction multiAction = (MultipleKeyAction)action;
            return multiAction.geValidKeyBindingPrecedence(this.focusProvider.getFocusOwner());
        }
        return action.getKeyBindingPrecedence();
    }

    private boolean blockKeyInput(KeyEvent event) {
        Component component = event.getComponent();
        if (component == null) {
            return false;
        }
        JRootPane rootPane = SwingUtilities.getRootPane(component);
        if (rootPane == null) {
            return true;
        }
        Component glassPane = rootPane.getGlassPane();
        return glassPane instanceof GGlassPane && ((GGlassPane)glassPane).isBusy();
    }

    private boolean actionInProgress(KeyEvent event) {
        boolean wasInProgress;
        boolean bl = wasInProgress = this.inProgressAction != null;
        if (event.getID() == 402) {
            DockingKeyBindingAction action = this.inProgressAction;
            this.inProgressAction = null;
            KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(event);
            SwingUtilities.notifyAction(action, keyStroke, event, event.getSource(), event.getModifiersEx());
        }
        return wasInProgress;
    }

    private boolean isValidContextForKeyStroke(KeyStroke keyStroke) {
        Window activeWindow = this.focusProvider.getActiveWindow();
        if (activeWindow instanceof DockingDialog) {
            DockingDialog dialog = (DockingDialog)activeWindow;
            return !dialog.isModal();
        }
        return true;
    }

    private boolean willBeHandledByTextComponent(KeyEvent event) {
        Component destination = event.getComponent();
        if (destination == null) {
            Component focusOwner;
            destination = focusOwner = this.focusProvider.getFocusOwner();
        }
        if (!(destination instanceof JTextComponent)) {
            return false;
        }
        if (!this.isModified(event)) {
            return true;
        }
        return this.hasRegisteredKeyBinding((JTextComponent)destination, event);
    }

    private boolean isModified(KeyEvent e) {
        return e.isAltDown() || e.isAltGraphDown() || e.isMetaDown() || e.isControlDown();
    }

    private boolean hasRegisteredKeyBinding(JComponent c, KeyEvent event) {
        KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(event);
        Action action = this.getJavaActionForComponent(c, keyStroke);
        return action != null;
    }

    private boolean throwAssertException() {
        throw new AssertException("New precedence added to KeyBindingPrecedence?");
    }

    private boolean processReservedKeyActionsPrecedence(DockingKeyBindingAction action, KeyEvent event) {
        if (!action.isReservedKeybindingPrecedence()) {
            return false;
        }
        if (this.inProgressAction != null) {
            return true;
        }
        this.inProgressAction = action;
        return true;
    }

    private boolean processKeyListenerPrecedence(DockingKeyBindingAction action, KeyBindingPrecedence keyBindingPrecedence, KeyEvent e) {
        if (this.processActionAtPrecedence(KeyBindingPrecedence.KeyListenerLevel, keyBindingPrecedence, action, e)) {
            return true;
        }
        return this.processComponentKeyListeners(e);
    }

    private boolean processComponentActionMapPrecedence(DockingKeyBindingAction action, KeyBindingPrecedence keyBindingPrecedence, KeyEvent event) {
        if (this.processActionAtPrecedence(KeyBindingPrecedence.ActionMapLevel, keyBindingPrecedence, action, event)) {
            return true;
        }
        KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(event);
        return this.processInputAndActionMaps(event, keyStroke);
    }

    private boolean processActionAtPrecedence(KeyBindingPrecedence precedence, KeyBindingPrecedence keyBindingPrecedence, DockingKeyBindingAction action, KeyEvent event) {
        if (keyBindingPrecedence != precedence) {
            return false;
        }
        if (this.inProgressAction != null) {
            return true;
        }
        this.inProgressAction = action;
        event.consume();
        return true;
    }

    private boolean processComponentKeyListeners(KeyEvent keyEvent) {
        KeyListener[] keyListeners;
        Component focusOwner = this.focusProvider.getFocusOwner();
        if (focusOwner == null) {
            return false;
        }
        block5: for (KeyListener listener : keyListeners = focusOwner.getKeyListeners()) {
            int id = keyEvent.getID();
            switch (id) {
                case 400: {
                    listener.keyTyped(keyEvent);
                    continue block5;
                }
                case 401: {
                    listener.keyPressed(keyEvent);
                    continue block5;
                }
                case 402: {
                    listener.keyReleased(keyEvent);
                }
            }
        }
        return keyEvent.isConsumed();
    }

    private boolean processInputAndActionMaps(KeyEvent keyEvent, KeyStroke keyStroke) {
        Component focusOwner = this.focusProvider.getFocusOwner();
        if (focusOwner == null || !focusOwner.isEnabled() || !(focusOwner instanceof JComponent)) {
            return false;
        }
        JComponent jComponent = (JComponent)focusOwner;
        Action action = this.getJavaActionForComponent(jComponent, keyStroke);
        if (action != null) {
            return SwingUtilities.notifyAction(action, keyStroke, keyEvent, keyEvent.getSource(), keyEvent.getModifiersEx());
        }
        return false;
    }

    private Action getJavaActionForComponent(JComponent jComponent, KeyStroke keyStroke) {
        Action action = KeyBindingUtils.getAction(jComponent, keyStroke, 0);
        if (action != null) {
            return action;
        }
        action = KeyBindingUtils.getAction(jComponent, keyStroke, 1);
        return action;
    }

    private DockingKeyBindingAction getDockingKeyBindingActionForEvent(KeyEvent event) {
        DockingWindowManager activeManager = this.getActiveDockingWindowManager();
        if (activeManager == null) {
            return null;
        }
        KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(event);
        DockingKeyBindingAction bindingAction = (DockingKeyBindingAction)activeManager.getActionForKeyStroke(keyStroke);
        return bindingAction;
    }

    private DockingWindowManager getActiveDockingWindowManager() {
        Window activeWindow = this.focusProvider.getActiveWindow();
        if (activeWindow == null) {
            return null;
        }
        DockingWindowManager activeManager = DockingWindowManager.getActiveInstance();
        if (activeManager == null) {
            return null;
        }
        DockingWindowManager managingInstance = KeyBindingOverrideKeyEventDispatcher.getDockingWindowManagerForWindow(activeWindow);
        if (managingInstance != null) {
            return managingInstance;
        }
        return activeManager;
    }

    private static DockingWindowManager getDockingWindowManagerForWindow(Window activeWindow) {
        DockingWindowManager manager = DockingWindowManager.getInstance(activeWindow);
        if (manager != null) {
            return manager;
        }
        if (activeWindow instanceof DockingDialog) {
            DockingDialog dockingDialog = (DockingDialog)activeWindow;
            return dockingDialog.getOwningWindowManager();
        }
        return null;
    }

    void setFocusOwnerProvider(FocusOwnerProvider focusProvider) {
        this.focusProvider = focusProvider;
    }
}

