/*
 * Decompiled with CFR 0.152.
 */
package docking;

import docking.ComponentPlaceholder;
import docking.DockingFrame;
import docking.DockingWindowManager;
import docking.DropTargetFactory;
import docking.DropTargetHandler;
import docking.Node;
import docking.RootNode;
import docking.StatusBar;
import docking.WindowNode;
import generic.util.WindowUtilities;
import ghidra.framework.OperatingSystem;
import ghidra.framework.Platform;
import ghidra.util.bean.GGlassPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import org.jdom.Content;
import org.jdom.Element;

class DetachedWindowNode
extends WindowNode {
    private Window window;
    private Node child;
    private Rectangle bounds;
    private StatusBar statusBar;
    private JComponent childComp;
    private DropTargetHandler dropTargetHandler;
    private DropTargetFactory dropTargetFactory;

    DetachedWindowNode(DockingWindowManager mgr, Node parent, Node child, DropTargetFactory factory) {
        super(mgr);
        this.parent = parent;
        this.child = child;
        this.dropTargetFactory = factory;
        child.parent = this;
        this.bounds = new Rectangle(0, 0, 0, 0);
    }

    DetachedWindowNode(Element elem, DockingWindowManager mgr, Node parent, DropTargetFactory factory, List<ComponentPlaceholder> list) {
        super(mgr);
        this.parent = parent;
        this.dropTargetFactory = factory;
        int x = Integer.parseInt(elem.getAttributeValue("X_POS"));
        int y = Integer.parseInt(elem.getAttributeValue("Y_POS"));
        int width = Integer.parseInt(elem.getAttributeValue("WIDTH"));
        int height = Integer.parseInt(elem.getAttributeValue("HEIGHT"));
        this.bounds = new Rectangle(x, y, width, height);
        Element childElement = (Element)elem.getChildren().get(0);
        this.child = this.processChildElement(childElement, mgr, this, list);
    }

    void setInitialLocation(int x, int y) {
        this.bounds.x = x;
        this.bounds.y = y;
    }

    void updateTitle() {
        if (this.window instanceof JDialog) {
            ((JDialog)this.window).setTitle(this.generateTitle());
        } else if (this.window instanceof JFrame) {
            ((JFrame)this.window).setTitle(this.generateTitle());
        }
    }

    @Override
    String getTitle() {
        if (this.window instanceof JDialog) {
            return ((JDialog)this.window).getTitle();
        }
        if (this.window instanceof JFrame) {
            return ((JFrame)this.window).getTitle();
        }
        return "";
    }

    @Override
    String getDescription() {
        return "Detached Node: " + this.getTitle();
    }

    public String toString() {
        return this.printTree();
    }

    @Override
    List<Node> getChildren() {
        return Arrays.asList(this.child);
    }

    void setIcon(Image iconImage) {
        Frame frame = this.getFrameForWindow(this.window);
        if (frame != null) {
            this.setFrameIcon(frame, iconImage);
        }
    }

    private void setFrameIcon(Frame frame, Image image) {
        ArrayList<Image> list = new ArrayList<Image>();
        list.add(image);
        this.setFrameIcon(frame, list);
    }

    private void setFrameIcon(Frame frame, List<Image> images) {
        if (Platform.CURRENT_PLATFORM.getOperatingSystem() == OperatingSystem.MAC_OS_X) {
            return;
        }
        if (images != null) {
            frame.setIconImages(images);
        }
    }

    private Frame getFrameForWindow(Window coolWindow) {
        if (coolWindow == null) {
            return null;
        }
        if (coolWindow instanceof Frame) {
            return (Frame)coolWindow;
        }
        Container windowParent = coolWindow.getParent();
        if (windowParent instanceof Window) {
            return this.getFrameForWindow((Window)windowParent);
        }
        return null;
    }

    public JRootPane getRootPane() {
        if (this.window instanceof JDialog) {
            return ((JDialog)this.window).getRootPane();
        }
        if (this.window instanceof JFrame) {
            return ((JFrame)this.window).getRootPane();
        }
        return null;
    }

    Window getWindow() {
        return this.window;
    }

    @Override
    Container getContentPane() {
        if (this.window instanceof JDialog) {
            return ((JDialog)this.window).getContentPane();
        }
        if (this.window instanceof JFrame) {
            return ((JFrame)this.window).getContentPane();
        }
        return null;
    }

    @Override
    void populateActiveComponents(List<ComponentPlaceholder> list) {
        this.child.populateActiveComponents(list);
    }

    String generateTitle() {
        return this.generateTitle(true);
    }

    private String generateTitle(boolean includeToolName) {
        Object title = this.getTitleOfChildren();
        if (title == null) {
            title = "";
        }
        if (includeToolName) {
            title = (String)title + " [" + ((RootNode)this.parent).getToolName() + "]";
        }
        return title;
    }

    private String getTitleOfChildren() {
        ArrayList<ComponentPlaceholder> placeholders = new ArrayList<ComponentPlaceholder>();
        this.child.populateActiveComponents(placeholders);
        List<String> titles = this.generateTitles(placeholders);
        boolean firstItem = true;
        StringBuffer buf = new StringBuffer();
        for (String title : titles) {
            if (!firstItem) {
                buf.append(", ");
            }
            firstItem = false;
            buf.append(title);
        }
        return buf.toString();
    }

    /*
     * WARNING - void declaration
     */
    private List<String> generateTitles(List<ComponentPlaceholder> placeholders) {
        HashMap providerNameToPlacholdersMap = new HashMap();
        for (ComponentPlaceholder placeholder : placeholders) {
            void var6_6;
            String providerName = placeholder.getProvider().getName();
            List list = (List)providerNameToPlacholdersMap.get(providerName);
            if (list == null) {
                ArrayList arrayList = new ArrayList();
                providerNameToPlacholdersMap.put(providerName, arrayList);
            }
            var6_6.add(placeholder);
        }
        HashMap providerNameToTitlesMap = new HashMap();
        Set entrySet = providerNameToPlacholdersMap.entrySet();
        for (Map.Entry entry : entrySet) {
            String providerName = (String)entry.getKey();
            List placeholdersList = (List)entry.getValue();
            ArrayList<String> titles = new ArrayList<String>();
            if (placeholdersList.size() == 1) {
                titles.add(((ComponentPlaceholder)placeholdersList.get(0)).getTitle());
            } else {
                for (ComponentPlaceholder placeholder : placeholdersList) {
                    titles.add(placeholder.getTabText());
                }
            }
            providerNameToTitlesMap.put(providerName, titles);
        }
        ArrayList<String> finalTitles = new ArrayList<String>();
        Set set = providerNameToTitlesMap.entrySet();
        for (Map.Entry entry : set) {
            String providerName = (String)entry.getKey();
            List titles = (List)entry.getValue();
            if (titles.size() == 1) {
                finalTitles.add((String)titles.get(0));
                continue;
            }
            StringBuffer buffy = new StringBuffer(providerName);
            buffy.append(" [ ");
            boolean firstItem = true;
            for (String title : titles) {
                if (!firstItem) {
                    buffy.append(", ");
                }
                firstItem = false;
                buffy.append(title);
            }
            buffy.append(" ]");
            finalTitles.add(buffy.toString());
        }
        Collections.sort(finalTitles);
        return finalTitles;
    }

    private void createWindow(JComponent comp) {
        RootNode root = (RootNode)this.parent;
        this.window = this.winMgr.isWindowsOnTop() || root.isModal() ? this.createDialog(root) : this.createFrame();
        if (this.dropTargetFactory != null) {
            this.dropTargetHandler = this.dropTargetFactory.createDropTargetHandler(this.window);
        }
        this.setIcon(this.winMgr.getRootFrame().getIconImage());
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)comp, "Center");
        this.statusBar = new StatusBar();
        contentPane.add((Component)this.statusBar, "South");
        this.window.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DetachedWindowNode.this.close();
            }

            @Override
            public void windowActivated(WindowEvent e) {
                DetachedWindowNode.this.winMgr.setActive(DetachedWindowNode.this.window, true);
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
                DetachedWindowNode.this.winMgr.setActive(DetachedWindowNode.this.window, false);
            }
        });
        this.adjustBounds();
        this.window.setBounds(this.bounds);
        this.window.setVisible(true);
    }

    private void adjustBounds() {
        if (this.bounds.height == 0 || this.bounds.width == 0) {
            this.window.pack();
            Dimension d = this.window.getSize();
            this.bounds.height = d.height;
            this.bounds.width = d.width;
        }
        Window activeWindow = this.winMgr.getActiveWindow();
        Point p = this.bounds.getLocation();
        if (p.x == 0 && p.y == 0) {
            p = WindowUtilities.centerOnScreen((Component)activeWindow, (Dimension)this.bounds.getSize());
            this.bounds.setLocation(p);
        }
        WindowUtilities.ensureOnScreen((Component)activeWindow, (Rectangle)this.bounds);
    }

    private JFrame createFrame() {
        DockingFrame newWindow = new DockingFrame(this.generateTitle());
        newWindow.setDefaultCloseOperation(0);
        return newWindow;
    }

    private JDialog createDialog(RootNode root) {
        JDialog newWindow = null;
        newWindow = root.isModal() ? new JDialog((Dialog)root.getModalDialog(), this.generateTitle()) : new JDialog((Frame)root.getFrame(), this.generateTitle());
        newWindow.setDefaultCloseOperation(0);
        GGlassPane glassPane = new GGlassPane();
        newWindow.setGlassPane((Component)glassPane);
        glassPane.setVisible(true);
        return newWindow;
    }

    void setVisible(boolean state) {
        if (this.window != null) {
            this.window.setVisible(state);
        }
    }

    @Override
    boolean isVisible() {
        return this.window != null && this.window.isVisible();
    }

    void updateDialog() {
        if (this.window != null && this.childComp != null) {
            this.bounds = this.window.getBounds();
            this.winMgr.getMainWindow().requestFocus();
            this.getContentPane().remove(this.childComp);
            this.window.dispose();
            this.createWindow(this.childComp);
        }
    }

    void update() {
        if (!this.invalid) {
            return;
        }
        if (this.childComp != null) {
            this.getContentPane().remove(this.childComp);
        }
        this.childComp = this.child.getComponent();
        if (this.childComp != null) {
            if (this.window == null) {
                this.createWindow(this.childComp);
            } else {
                this.getContentPane().add((Component)this.childComp, "Center");
                this.window.validate();
                this.window.repaint();
            }
        } else if (this.window != null) {
            this.bounds = this.window.getBounds();
            this.window.setVisible(false);
            this.window.dispose();
            this.window = null;
        }
        this.invalid = false;
        this.updateTitle();
        this.clearContextTypes();
        ((RootNode)this.parent).notifyWindowChanged(this);
    }

    @Override
    void dispose() {
        if (this.dropTargetHandler != null) {
            this.dropTargetHandler.dispose();
        }
        this.winMgr.getMainWindow().requestFocus();
        if (this.window != null) {
            this.window.setVisible(false);
            this.window.dispose();
            this.window = null;
        }
        if (this.child != null) {
            this.child.parent = null;
            this.child.dispose();
            this.child = null;
        }
    }

    @Override
    void close() {
        this.child.close();
    }

    @Override
    JComponent getComponent() {
        return null;
    }

    @Override
    void removeNode(Node node) {
        if (node != this.child) {
            throw new IllegalArgumentException();
        }
        if (this.window != null) {
            this.window.setVisible(false);
            this.window.dispose();
        }
        this.child.parent = null;
        this.child = null;
        this.parent.removeNode(this);
    }

    @Override
    void replaceNode(Node oldNode, Node newNode) {
        if (oldNode == this.child) {
            this.child = newNode;
            newNode.parent = this;
            this.invalidate();
            this.winMgr.scheduleUpdate();
        }
    }

    @Override
    Element saveToXML() {
        if (this.window != null) {
            this.bounds = this.window.getBounds();
        }
        Element root = new Element("WINDOW_NODE");
        root.setAttribute("X_POS", "" + this.bounds.x);
        root.setAttribute("Y_POS", "" + this.bounds.y);
        root.setAttribute("WIDTH", "" + this.bounds.width);
        root.setAttribute("HEIGHT", "" + this.bounds.height);
        root.addContent((Content)this.child.saveToXML());
        return root;
    }

    @Override
    boolean contains(ComponentPlaceholder info) {
        if (this.child != null) {
            return this.child.contains(info);
        }
        return false;
    }

    public void setStatusText(String text) {
        if (this.statusBar != null) {
            this.statusBar.setStatusText(text);
        }
    }

    public void clearStatusMessages() {
        if (this.statusBar != null) {
            this.statusBar.clearStatusMessages();
        }
    }

    @Override
    void setMenuBar(JMenuBar menuBar) {
        if (this.window instanceof JDialog) {
            ((JDialog)this.window).setJMenuBar(menuBar);
        } else if (this.window instanceof JFrame) {
            ((JFrame)this.window).setJMenuBar(menuBar);
        }
    }

    @Override
    void validate() {
        if (this.window != null) {
            this.window.validate();
        }
    }

    @Override
    WindowNode getTopLevelNode() {
        return this;
    }
}

