/*
 * Decompiled with CFR 0.152.
 */
package agent.lldb.model.impl;

import SWIG.SBValue;
import SWIG.StateType;
import agent.lldb.manager.LldbReason;
import agent.lldb.model.iface2.LldbModelTargetObject;
import agent.lldb.model.iface2.LldbModelTargetRegisterBank;
import agent.lldb.model.iface2.LldbModelTargetStackFrameRegisterBank;
import agent.lldb.model.iface2.LldbModelTargetStackFrameRegisterContainer;
import agent.lldb.model.impl.LldbModelTargetObjectImpl;
import agent.lldb.model.impl.LldbModelTargetStackFrameImpl;
import agent.lldb.model.impl.LldbModelTargetStackFrameRegisterBankImpl;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

@TargetObjectSchemaInfo(name="RegisterContainer", attributeResync=TargetObjectSchema.ResyncMode.ALWAYS, attributes={@TargetAttributeType(name="General Purpose Registers", type=LldbModelTargetStackFrameRegisterBank.class, required=true), @TargetAttributeType(name="Floating Point Registers", type=LldbModelTargetStackFrameRegisterBank.class, required=false), @TargetAttributeType(type=LldbModelTargetStackFrameRegisterBank.class)})
public class LldbModelTargetStackFrameRegisterContainerImpl
extends LldbModelTargetObjectImpl
implements LldbModelTargetStackFrameRegisterContainer {
    public static final String NAME = "Registers";
    protected final LldbModelTargetStackFrameImpl frame;

    public LldbModelTargetStackFrameRegisterContainerImpl(LldbModelTargetStackFrameImpl frame) {
        super(frame.getModel(), (TargetObject)frame, NAME, "StackFrameRegisterContainer");
        this.frame = frame;
        this.requestAttributes(true);
    }

    public CompletableFuture<Void> requestAttributes(boolean refresh) {
        return this.getManager().listStackFrameRegisterBanks(this.frame.getFrame()).thenAccept(banks -> {
            List targetBanks;
            LldbModelTargetStackFrameRegisterContainerImpl lldbModelTargetStackFrameRegisterContainerImpl = this;
            synchronized (lldbModelTargetStackFrameRegisterContainerImpl) {
                targetBanks = banks.values().stream().map(this::getTargetRegisterBank).collect(Collectors.toList());
            }
            this.changeAttributes(List.of(), targetBanks, Map.of(), "Refreshed");
        });
    }

    @Override
    public LldbModelTargetObject getTargetRegisterBank(SBValue val) {
        TargetObject targetObject = this.getMapObject(val);
        if (targetObject != null) {
            LldbModelTargetObject targetBank = (LldbModelTargetObject)targetObject;
            targetBank.setModelObject(val);
            return targetBank;
        }
        return new LldbModelTargetStackFrameRegisterBankImpl(this, val);
    }

    public void threadStateChangedSpecific(StateType state, LldbReason reason) {
        if (state.equals(StateType.eStateStopped)) {
            this.requestAttributes(false).thenAccept(__ -> {
                for (Object attribute : this.getCachedAttributes().values()) {
                    if (!(attribute instanceof LldbModelTargetRegisterBank)) continue;
                    LldbModelTargetRegisterBank bank = (LldbModelTargetRegisterBank)attribute;
                    bank.threadStateChangedSpecific(state, reason);
                }
            });
        }
    }
}

