/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.renderers;

import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.util.function.Function;
import org.jungrapht.visualization.RenderContext;
import org.jungrapht.visualization.layout.model.LayoutModel;
import org.jungrapht.visualization.renderers.AbstractVertexRenderer;
import org.jungrapht.visualization.renderers.Renderer;

public class LightweightVertexRenderer<V, E>
extends AbstractVertexRenderer<V, E>
implements Renderer.Vertex<V, E> {
    protected Function<V, Shape> simpleVertexShapeFunction = n -> new Ellipse2D.Float(-10.0f, -10.0f, 20.0f, 20.0f);

    public void setVertexShapeFunction(Function<V, Shape> vertexShapeFunction) {
        this.simpleVertexShapeFunction = vertexShapeFunction;
    }

    public Function<V, Shape> getVertexShapeFunction() {
        return this.simpleVertexShapeFunction;
    }

    @Override
    protected Shape getVertexShape(RenderContext<V, E> renderContext, V vertex) {
        return renderContext.getVertexShapeFunction().apply(vertex);
    }

    @Override
    protected void paintIconForVertex(RenderContext<V, E> renderContext, LayoutModel<V> layoutModel, V v) {
        int[] coords = new int[2];
        Shape shape = this.prepareFinalVertexShape(renderContext, layoutModel, v, coords);
        this.paintShapeForVertex(renderContext, v, shape);
    }
}

