/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.function;

import ghidra.app.decompiler.DecompInterface;
import ghidra.app.decompiler.DecompileOptions;
import ghidra.app.decompiler.DecompileResults;
import ghidra.app.util.NamespaceUtils;
import ghidra.framework.cmd.BackgroundCommand;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.lang.PrototypeModel;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.SymbolType;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class DecompilerParallelConventionAnalysisCmd
extends BackgroundCommand {
    private static final String STD_NAMESPACE = "std";
    private Program program;
    private int decompilerTimeoutSecs;
    private DecompInterface decompiler;
    private Function function;

    public static DecompInterface createDecompilerInterface(Program program) throws IOException {
        DecompInterface newInterface = new DecompInterface();
        newInterface.toggleCCode(false);
        newInterface.toggleSyntaxTree(false);
        newInterface.setSimplificationStyle("paramid");
        DecompileOptions opts = new DecompileOptions();
        opts.setEliminateUnreachable(false);
        opts.grabFromProgram(program);
        newInterface.setOptions(opts);
        if (!newInterface.openProgram(program)) {
            throw new IOException("Unable to create decompiler for program: " + program);
        }
        return newInterface;
    }

    public DecompilerParallelConventionAnalysisCmd(Function func, DecompInterface decompilerInterface, int decompilerTimeoutSecs) {
        super("Identify Calling Convention", true, true, false);
        this.function = func;
        this.decompiler = decompilerInterface;
        this.decompilerTimeoutSecs = decompilerTimeoutSecs;
    }

    public boolean applyTo(DomainObject obj, TaskMonitor monitor) {
        this.program = (Program)obj;
        try {
            monitor.checkCanceled();
            monitor.setMessage("Decompile " + this.function.getName());
            this.setStatusMsg(null);
            this.analyzeFunction(this.function, monitor);
            String errMsg = this.getStatusMsg();
            if (errMsg != null && errMsg.length() > 0) {
                return false;
            }
        }
        catch (CancelledException errMsg) {
        }
        catch (Exception e) {
            this.setStatusMsg(e.getMessage());
            return false;
        }
        return true;
    }

    private boolean funcIsExternalGlue(Function func) {
        String blockName = this.program.getMemory().getBlock(func.getEntryPoint()).getName();
        return blockName.equals("EXTERNAL") || blockName.equals(".plt") || blockName.equals("__stub_helper");
    }

    private static boolean isInStdNamespace(Function function) {
        Namespace parentNamespace = function.getParentNamespace();
        return parentNamespace.getName().equals(STD_NAMESPACE) && parentNamespace.getParentNamespace().getID() == 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analyzeFunction(Function f, TaskMonitor monitor) {
        if (f == null || f.isThunk() || DecompilerParallelConventionAnalysisCmd.isInStdNamespace(f)) {
            return;
        }
        if (f.hasCustomVariableStorage() || !f.getCallingConventionName().equals("unknown")) {
            return;
        }
        if (f.isExternal()) {
            return;
        }
        if (this.funcIsExternalGlue(f)) {
            return;
        }
        SourceType signatureSource = f.getSignatureSource();
        try {
            DecompileResults decompRes = null;
            if (monitor.isCancelled()) {
                return;
            }
            f.setSignatureSource(SourceType.DEFAULT);
            decompRes = this.decompiler.decompileFunction(f, this.decompilerTimeoutSecs, monitor);
            this.setStatusMsg(decompRes.getErrorMessage());
            if (monitor.isCancelled()) {
                return;
            }
            if (!decompRes.decompileCompleted()) {
                return;
            }
            HighFunction highFunction = decompRes.getHighFunction();
            String modelName = highFunction.getFunctionPrototype().getModelName();
            if (!modelName.equals("default")) {
                signatureSource = this.updateCallingConvention(f, signatureSource, highFunction, modelName);
            }
            String errMsg = this.getStatusMsg();
            if (!monitor.isCancelled() && errMsg != null && errMsg.length() != 0) {
                Msg.debug((Object)((Object)this), (Object)("  Failed to decompile function: " + f.getName() + " - " + errMsg));
            }
        }
        catch (Exception e) {
            if (!monitor.isCancelled()) {
                Object errMsg = e.getMessage();
                if (errMsg == null) {
                    errMsg = "Error decompiling function: " + e;
                }
                this.setStatusMsg((String)errMsg);
            }
        }
        finally {
            f.setSignatureSource(signatureSource);
        }
    }

    private SourceType updateCallingConvention(Function f, SourceType signatureSource, HighFunction highFunction, String modelName) throws InvalidInputException {
        PrototypeModel callingConvention;
        Namespace parentNamespace = f.getParentNamespace();
        if (f.getParameterCount() + 1 == highFunction.getFunctionPrototype().getNumParams() && parentNamespace.getID() != 0L && !parentNamespace.getName().equals(STD_NAMESPACE) && (callingConvention = this.program.getCompilerSpec().getCallingConvention("__thiscall")) != null) {
            modelName = "__thiscall";
        }
        if (modelName.equals("__stdcall") && f.getStackPurgeSize() == 0 && f.getParameterCount() > 0 && this.program.getLanguageID().getIdAsString().startsWith("x86:LE:32")) {
            modelName = "__cdecl";
        }
        if (parentNamespace.getSymbol().getSymbolType() == SymbolType.NAMESPACE && modelName.equals("__thiscall")) {
            NamespaceUtils.convertNamespaceToClass((Namespace)f.getParentNamespace());
        }
        f.setCallingConvention(modelName);
        if (signatureSource == SourceType.DEFAULT) {
            signatureSource = SourceType.ANALYSIS;
        }
        return signatureSource;
    }
}

