/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.symbol;

import db.DBRecord;
import ghidra.program.database.data.DataTypeUtilities;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.AbstractFloatDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.listing.VariableUtilities;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.trace.database.symbol.AbstractDBTraceSymbol;
import ghidra.trace.database.symbol.DBTraceFunctionSymbol;
import ghidra.trace.database.symbol.DBTraceNamespaceSymbol;
import ghidra.trace.database.symbol.DBTraceSymbolManager;
import ghidra.trace.model.symbol.TraceVariableSymbol;
import ghidra.util.LockHold;
import ghidra.util.database.DBCachedObjectStore;
import ghidra.util.database.DBObjectColumn;
import ghidra.util.database.annot.DBAnnotatedColumn;
import ghidra.util.database.annot.DBAnnotatedField;
import ghidra.util.exception.InvalidInputException;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.locks.Lock;

public abstract class AbstractDBTraceVariableSymbol
extends AbstractDBTraceSymbol
implements TraceVariableSymbol {
    static final String DATATYPE_COLUMN_NAME = "DataType";
    static final String STORAGE_COLUMN_NAME = "Storage";
    static final String COMMENT_COLUMN_NAME = "Comment";
    @DBAnnotatedColumn(value="DataType")
    static DBObjectColumn DATATYPE_COLUMN;
    @DBAnnotatedColumn(value="Storage")
    static DBObjectColumn STORAGE_COLUMN;
    @DBAnnotatedColumn(value="Comment")
    static DBObjectColumn COMMENT_COLUMN;
    @DBAnnotatedField(column="DataType")
    private long dataTypeID;
    @DBAnnotatedField(column="Storage")
    private int storageID;
    @DBAnnotatedField(column="Comment")
    private String comment;
    protected DataType dataType;
    protected VariableStorage storage;
    protected Address address;

    public AbstractDBTraceVariableSymbol(DBTraceSymbolManager manager, DBCachedObjectStore<?> store, DBRecord record) {
        super(manager, store, record);
    }

    @Override
    protected void fresh(boolean created) throws IOException {
        super.fresh(created);
        if (created) {
            return;
        }
        this.dataType = this.manager.dataTypeManager.getDataType(this.dataTypeID);
        DBTraceSymbolManager.DBTraceVariableStorageEntry storageEntry = (DBTraceSymbolManager.DBTraceVariableStorageEntry)this.manager.storageStore.getObjectAt((long)this.storageID);
        if (storageEntry == null) {
            throw new IOException("Database is corrupt. Cannot find VariableStorage entry " + this.storageID);
        }
        this.storage = storageEntry.getStorage();
        this.address = AddressSpace.VARIABLE_SPACE.getAddress((long)this.storageID);
    }

    protected void set(String name, DBTraceNamespaceSymbol parent, DataType dt, VariableStorage storage, SourceType source) {
        super.set(name, parent, source);
        this.dataTypeID = this.manager.dataTypeManager.getResolvedID(dt);
        this.dataType = this.manager.dataTypeManager.getDataType(this.dataTypeID);
        this.storageID = this.manager.findOrRecordVariableStorage(storage);
        this.update(DATATYPE_COLUMN, STORAGE_COLUMN);
        this.storage = storage;
        this.address = AddressSpace.VARIABLE_SPACE.getAddress((long)this.storageID);
    }

    protected VariableStorage adjustStorage(VariableStorage s) {
        return s;
    }

    @Override
    public String toString() {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.readLock());){
            String string = String.format("[%s %s@%s]", this.getDataType().getName(), this.getName(), this.getVariableStorage());
            return string;
        }
    }

    @Override
    public Address getAddress() {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.readLock());){
            Address address = this.address;
            return address;
        }
    }

    public Object getObject() {
        return this;
    }

    public Symbol getSymbol() {
        return this;
    }

    public int getLength() {
        return this.getDataType().getLength();
    }

    public boolean isValid() {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.readLock());){
            VariableStorage s = this.getVariableStorage();
            if (!s.isValid()) {
                boolean bl = false;
                return bl;
            }
            if (this.dataType instanceof AbstractFloatDataType) {
                boolean bl = true;
                return bl;
            }
            boolean bl = s.size() == this.getDataType().getLength();
            return bl;
        }
    }

    protected void doSetDataType(DataType dt) {
        this.dataTypeID = this.manager.dataTypeManager.getResolvedID(dt);
        this.dataType = this.manager.dataTypeManager.getDataType(this.dataTypeID);
        this.update(DATATYPE_COLUMN);
    }

    protected void doSetStorage(VariableStorage s) {
        this.storage = s;
        this.update(STORAGE_COLUMN);
    }

    protected void doSetStorageAndDataType(VariableStorage s, DataType dt) {
        this.doSetDataType(dt);
        this.doSetStorage(this.adjustStorage(s));
    }

    protected void doUpdatesAfterSetDataType() {
    }

    public void setDataType(DataType dt, VariableStorage s, boolean force, SourceType source) throws InvalidInputException {
        s = this.adjustStorage(s);
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.writeLock());){
            dt = VariableUtilities.checkDataType((DataType)dt, (boolean)false, (int)this.getLength(), (Program)this.getProgram());
            DBTraceFunctionSymbol function = this.getFunction();
            s = VariableUtilities.checkStorage((Function)function, (VariableStorage)s, (DataType)dt, (boolean)force);
            VariableUtilities.checkVariableConflict((Function)function, (Variable)this, (VariableStorage)s, (boolean)force);
            this.doSetStorageAndDataType(s, dt);
            this.doUpdatesAfterSetDataType();
        }
    }

    protected VariableStorage doDeriveStorageForSetDataType(DataType dt, boolean alignStack, boolean force) throws InvalidInputException {
        try {
            VariableStorage s = VariableUtilities.resizeStorage((VariableStorage)this.getVariableStorage(), (DataType)dt, (boolean)alignStack, (Function)this.getFunction());
            VariableUtilities.checkStorage((VariableStorage)s, (DataType)dt, (boolean)force);
            VariableUtilities.checkVariableConflict((Function)this.getFunction(), (Variable)this, (VariableStorage)s, (boolean)force);
            return s;
        }
        catch (InvalidInputException e) {
            if (!force) {
                throw e;
            }
            return VariableStorage.UNASSIGNED_STORAGE;
        }
    }

    public void setDataType(DataType dt, boolean alignStack, boolean force, SourceType source) throws InvalidInputException {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.writeLock());){
            dt = VariableUtilities.checkDataType((DataType)dt, (boolean)false, (int)this.getLength(), (Program)this.getProgram());
            VariableStorage s = this.doDeriveStorageForSetDataType(dt, alignStack, force);
            this.doSetStorageAndDataType(s, dt);
            this.doUpdatesAfterSetDataType();
        }
    }

    public void setDataType(DataType dt, SourceType source) throws InvalidInputException {
        this.setDataType(dt, true, false, source);
    }

    public DataType getDataType() {
        return this.dataType;
    }

    @Override
    public abstract DBTraceFunctionSymbol getFunction();

    public void setComment(String comment) {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.writeLock());){
            this.comment = comment;
            this.update(COMMENT_COLUMN);
        }
    }

    public String getComment() {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.readLock());){
            String string = this.comment;
            return string;
        }
    }

    public VariableStorage getVariableStorage() {
        return this.storage;
    }

    public Varnode getFirstStorageVarnode() {
        VariableStorage s = this.getVariableStorage();
        return s == null ? null : s.getFirstVarnode();
    }

    public Varnode getLastStorageVarnode() {
        VariableStorage s = this.getVariableStorage();
        return s == null ? null : s.getLastVarnode();
    }

    public boolean isStackVariable() {
        VariableStorage s = this.getVariableStorage();
        return s == null ? false : s.isStackStorage();
    }

    public boolean hasStackStorage() {
        VariableStorage s = this.getVariableStorage();
        return s == null ? false : s.hasStackStorage();
    }

    public boolean isRegisterVariable() {
        VariableStorage s = this.getVariableStorage();
        return s == null ? false : s.isRegisterStorage();
    }

    public Register getRegister() {
        VariableStorage s = this.getVariableStorage();
        return s == null ? null : s.getRegister();
    }

    public List<Register> getRegisters() {
        VariableStorage s = this.getVariableStorage();
        return s == null ? null : s.getRegisters();
    }

    public Address getMinAddress() {
        VariableStorage s = this.getVariableStorage();
        return s == null ? null : s.getMinAddress();
    }

    public int getStackOffset() {
        VariableStorage s = this.getVariableStorage();
        if (s == null) {
            throw new UnsupportedOperationException("Variable has no storage");
        }
        return s.getStackOffset();
    }

    public boolean isMemoryVariable() {
        VariableStorage s = this.getVariableStorage();
        return s == null ? false : s.isMemoryStorage();
    }

    public boolean isUniqueVariable() {
        VariableStorage s = this.getVariableStorage();
        return s == null ? false : s.isHashStorage();
    }

    public boolean isCompoundVariable() {
        VariableStorage s = this.getVariableStorage();
        return s == null ? false : s.isCompoundStorage();
    }

    public boolean hasAssignedStorage() {
        VariableStorage s = this.getVariableStorage();
        return s == null ? false : !s.isUnassignedStorage();
    }

    protected static boolean doHasCustomStorage(Variable v) {
        Function f = v.getFunction();
        return f == null || f.hasCustomVariableStorage();
    }

    public static boolean areEquivalent(Variable v1, Variable v2) {
        boolean eitherCustom;
        if (v1 == null && v2 == null) {
            return true;
        }
        if (v1 == null || v2 == null) {
            return false;
        }
        if (v1 == v2) {
            return true;
        }
        if (v1 instanceof Parameter != v2 instanceof Parameter) {
            return false;
        }
        if (v1 instanceof Parameter) {
            Parameter p1 = (Parameter)v1;
            Parameter p2 = (Parameter)v2;
            if (p1.getOrdinal() != p2.getOrdinal()) {
                return false;
            }
        }
        if (v1.getFirstUseOffset() != v2.getFirstUseOffset()) {
            return false;
        }
        boolean bl = eitherCustom = AbstractDBTraceVariableSymbol.doHasCustomStorage(v1) || AbstractDBTraceVariableSymbol.doHasCustomStorage(v2);
        if (eitherCustom && !Objects.equals(v1.getVariableStorage(), v2.getVariableStorage())) {
            return false;
        }
        return DataTypeUtilities.isSameOrEquivalentDataType((DataType)v1.getDataType(), (DataType)v2.getDataType());
    }

    public boolean isEquivalent(Variable variable) {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.readLock());){
            boolean bl = AbstractDBTraceVariableSymbol.areEquivalent(this, variable);
            return bl;
        }
    }

    public int compareTo(Variable that) {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.readLock());){
            int n = VariableUtilities.compare((Variable)this, (Variable)that);
            return n;
        }
    }

    @Override
    public boolean delete() {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.writeLock());){
            DBTraceFunctionSymbol function = this.getFunction();
            if (function != null) {
                function.doDeleteVariable(this);
            }
            boolean bl = super.delete();
            return bl;
        }
    }
}

