/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.listing;

import com.google.common.collect.Range;
import db.DBRecord;
import ghidra.docking.settings.Settings;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.lang.Language;
import ghidra.trace.database.DBTraceUtils;
import ghidra.trace.database.data.DBTraceDataSettingsAdapter;
import ghidra.trace.database.listing.AbstractDBTraceCodeUnit;
import ghidra.trace.database.listing.AbstractDBTraceDataComponent;
import ghidra.trace.database.listing.DBTraceCodeSpace;
import ghidra.trace.database.listing.DBTraceDefinedDataAdapter;
import ghidra.trace.database.map.DBTraceAddressSnapRangePropertyMapTree;
import ghidra.util.LockHold;
import ghidra.util.database.DBCachedObjectStore;
import ghidra.util.database.DBObjectColumn;
import ghidra.util.database.annot.DBAnnotatedColumn;
import ghidra.util.database.annot.DBAnnotatedField;
import ghidra.util.database.annot.DBAnnotatedObjectInfo;
import java.io.IOException;
import java.util.concurrent.locks.Lock;

@DBAnnotatedObjectInfo(version=0)
public class DBTraceData
extends AbstractDBTraceCodeUnit<DBTraceData>
implements DBTraceDefinedDataAdapter {
    private static final String TABLE_NAME = "Data";
    static final String LANGUAGE_COLUMN_NAME = "Langauge";
    static final String DATATYPE_COLUMN_NAME = "DataType";
    @DBAnnotatedColumn(value="Langauge")
    static DBObjectColumn LANGUAGE_COLUMN;
    @DBAnnotatedColumn(value="DataType")
    static DBObjectColumn DATATYPE_COLUMN;
    @DBAnnotatedField(column="Langauge")
    private int langKey;
    @DBAnnotatedField(column="DataType")
    private long dataTypeID;
    protected Language language;
    protected DataType dataType;
    protected DataType baseDataType;
    protected Settings defaultSettings;
    protected AbstractDBTraceDataComponent[] componentCache = null;

    static String tableName(AddressSpace space, long threadKey, int frameLevel) {
        return DBTraceUtils.tableName(TABLE_NAME, space, threadKey, frameLevel);
    }

    public DBTraceData(DBTraceCodeSpace space, DBTraceAddressSnapRangePropertyMapTree<DBTraceData, ?> tree, DBCachedObjectStore<?> store, DBRecord record) {
        super(space, tree, store, record);
    }

    @Override
    protected void fresh(boolean created) throws IOException {
        super.fresh(created);
        if (created) {
            return;
        }
        this.language = this.space.manager.languageManager.getLanguageByKey(this.langKey);
        if (this.language == null) {
            throw new IOException("Data table is corrupt. Missing langauge: " + this.langKey);
        }
        this.dataType = this.space.dataTypeManager.getDataType(this.dataTypeID);
        if (this.dataType == null) {
            throw new IOException("Data table is corrupt. Missing datatype: " + this.dataTypeID);
        }
        this.baseDataType = DBTraceData.getBaseDataType(this.dataType);
        int dtLen = this.getDataTypeLength();
        if ((long)dtLen != this.range.getLength() && dtLen != -1) {
            throw new IOException("Data table is corrupt. Data unit and its datatype disagree on length.");
        }
        this.defaultSettings = this.dataType.getDefaultSettings();
    }

    protected void setRecordValue(DBTraceData value) {
    }

    protected DBTraceData getRecordValue() {
        return this;
    }

    protected void set(Language language, DataType dataType) {
        this.language = language;
        this.langKey = this.space.manager.languageManager.getKeyForLanguage(language);
        this.dataTypeID = this.space.dataTypeManager.getResolvedID(dataType);
        this.dataType = this.space.dataTypeManager.getDataType(this.dataTypeID);
        assert (this.dataType != null);
        this.baseDataType = DBTraceData.getBaseDataType(this.dataType);
        this.defaultSettings = this.dataType.getDefaultSettings();
        this.update(LANGUAGE_COLUMN, DATATYPE_COLUMN);
    }

    protected int getDataTypeLength() {
        if (this.baseDataType instanceof Pointer) {
            return this.language.getDefaultDataSpace().getPointerSize();
        }
        return this.dataType.getLength();
    }

    public static DataType getBaseDataType(DataType dt) {
        if (dt instanceof TypeDef) {
            return ((TypeDef)dt).getBaseDataType();
        }
        return dt;
    }

    @Override
    public void delete() {
        try (LockHold hold = LockHold.lock((Lock)this.space.lock.writeLock());){
            this.space.dataMapSpace.deleteData(this);
        }
        this.space.definedData.unitRemoved(this);
    }

    @Override
    public void setEndSnap(long endSnap) {
        Range<Long> oldSpan;
        try (LockHold hold = LockHold.lock((Lock)this.space.lock.writeLock());){
            oldSpan = this.getLifespan();
            super.setEndSnap(endSnap);
        }
        this.space.definedData.unitSpanChanged(oldSpan, this);
    }

    @Override
    public Language getLanguage() {
        return this.language;
    }

    int getLanguageKey() {
        return this.langKey;
    }

    public String toString() {
        return this.doToString();
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public DataType getBaseDataType() {
        return this.baseDataType;
    }

    @Override
    public DBTraceDefinedDataAdapter getParent() {
        return null;
    }

    @Override
    public DBTraceData getRoot() {
        return this;
    }

    public int getRootOffset() {
        return 0;
    }

    public int getParentOffset() {
        return 0;
    }

    @Override
    public AbstractDBTraceDataComponent[] doGetComponentCache() {
        if (this.componentCache == null) {
            this.componentCache = new AbstractDBTraceDataComponent[this.getNumComponents()];
        }
        return this.componentCache;
    }

    public int[] getComponentPath() {
        return EMPTY_INT_ARRAY;
    }

    public int getComponentIndex() {
        return -1;
    }

    public int getComponentLevel() {
        return 0;
    }

    public String getFieldName() {
        return null;
    }

    public String getPathName() {
        return this.getPrimarySymbolOrDynamicName();
    }

    public String getComponentPathName() {
        return null;
    }

    @Override
    public StringBuilder getPathName(StringBuilder builder, boolean includeRootSymbol) {
        if (includeRootSymbol) {
            return builder.append(this.getPrimarySymbolOrDynamicName());
        }
        return builder;
    }

    @Override
    public DBTraceDataSettingsAdapter.DBTraceDataSettingsSpace getSettingsSpace(boolean createIfAbsent) {
        return this.getTrace().getDataSettingsAdapter().get(this.space, createIfAbsent);
    }

    public Settings getDefaultSettings() {
        return this.defaultSettings;
    }
}

