/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.context;

import com.google.common.collect.Range;
import db.DBHandle;
import db.DBRecord;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.DefaultProgramContext;
import ghidra.program.model.listing.ProgramContext;
import ghidra.program.util.ProgramContextImpl;
import ghidra.trace.database.DBTrace;
import ghidra.trace.database.context.DBTraceRegisterContextRegisterSpace;
import ghidra.trace.database.context.DBTraceRegisterContextSpace;
import ghidra.trace.database.language.DBTraceLanguageManager;
import ghidra.trace.database.map.DBTraceAddressSnapRangePropertyMapTree;
import ghidra.trace.database.space.AbstractDBTraceSpaceBasedManager;
import ghidra.trace.database.space.DBTraceDelegatingManager;
import ghidra.trace.database.thread.DBTraceThread;
import ghidra.trace.database.thread.DBTraceThreadManager;
import ghidra.trace.model.TraceAddressSnapRange;
import ghidra.trace.model.context.TraceRegisterContextManager;
import ghidra.trace.model.thread.TraceThread;
import ghidra.util.database.DBCachedObjectStore;
import ghidra.util.database.DBObjectColumn;
import ghidra.util.database.DBOpenMode;
import ghidra.util.database.annot.DBAnnotatedColumn;
import ghidra.util.database.annot.DBAnnotatedField;
import ghidra.util.database.annot.DBAnnotatedObjectInfo;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;

public class DBTraceRegisterContextManager
extends AbstractDBTraceSpaceBasedManager<DBTraceRegisterContextSpace, DBTraceRegisterContextRegisterSpace>
implements TraceRegisterContextManager,
DBTraceDelegatingManager<DBTraceRegisterContextSpace> {
    public static final String NAME = "RegisterContext";
    protected final DBTraceLanguageManager languageManager;
    protected final Map<Language, ProgramContext> defaultContexts = new HashMap<Language, ProgramContext>();

    public DBTraceRegisterContextManager(DBHandle dbh, DBOpenMode openMode, ReadWriteLock lock, TaskMonitor monitor, Language baseLanguage, DBTrace trace, DBTraceThreadManager threadManager, DBTraceLanguageManager languageManager) throws VersionException, IOException {
        super(NAME, dbh, openMode, lock, monitor, baseLanguage, trace, threadManager);
        this.languageManager = languageManager;
        this.loadSpaces();
    }

    @Override
    protected DBTraceRegisterContextSpace createSpace(AddressSpace space, AbstractDBTraceSpaceBasedManager.DBTraceSpaceEntry ent) throws VersionException, IOException {
        return new DBTraceRegisterContextSpace(this, this.dbh, space, ent);
    }

    @Override
    protected DBTraceRegisterContextRegisterSpace createRegisterSpace(AddressSpace space, DBTraceThread thread, AbstractDBTraceSpaceBasedManager.DBTraceSpaceEntry ent) throws VersionException, IOException {
        return new DBTraceRegisterContextRegisterSpace(this, this.dbh, space, ent, thread);
    }

    @Override
    public DBTraceRegisterContextSpace getForSpace(AddressSpace space, boolean createIfAbsent) {
        return (DBTraceRegisterContextSpace)super.getForSpace(space, createIfAbsent);
    }

    @Override
    public Lock readLock() {
        return this.lock.readLock();
    }

    @Override
    public Lock writeLock() {
        return this.lock.writeLock();
    }

    @Override
    public DBTraceRegisterContextSpace getRegisterContextSpace(AddressSpace space, boolean createIfAbsent) {
        return this.getForSpace(space, createIfAbsent);
    }

    @Override
    public DBTraceRegisterContextRegisterSpace getRegisterContextRegisterSpace(TraceThread thread, boolean createIfAbsent) {
        return (DBTraceRegisterContextRegisterSpace)this.getForRegisterSpace(thread, 0, createIfAbsent);
    }

    private ProgramContext generateDefaultContext(Language language) {
        ProgramContextImpl context = new ProgramContextImpl(language);
        language.applyContextSettings((DefaultProgramContext)context);
        return context;
    }

    public ProgramContext getDefaultContext(Language language) {
        return this.defaultContexts.computeIfAbsent(language, this::generateDefaultContext);
    }

    @Override
    public RegisterValue getDefaultValue(Language language, Register register, Address address) {
        return this.getDefaultContext(language).getDefaultValue(register, address);
    }

    @Override
    public void setValue(Language language, RegisterValue value, Range<Long> lifespan, AddressRange range) {
        this.delegateWriteV(range.getAddressSpace(), m -> m.setValue(language, value, lifespan, range));
    }

    @Override
    public void removeValue(Language language, Register register, Range<Long> span, AddressRange range) {
        this.delegateDeleteV(range.getAddressSpace(), m -> m.removeValue(language, register, span, range));
    }

    @Override
    public RegisterValue getValue(Language language, Register register, long snap, Address address) {
        return (RegisterValue)this.delegateRead(address.getAddressSpace(), m -> m.getValue(language, register, snap, address));
    }

    @Override
    public Map.Entry<TraceAddressSnapRange, RegisterValue> getEntry(Language language, Register register, long snap, Address address) {
        return (Map.Entry)this.delegateRead(address.getAddressSpace(), m -> m.getEntry(language, register, snap, address));
    }

    @Override
    public RegisterValue getValueWithDefault(Language language, Register register, long snap, Address address) {
        return (RegisterValue)this.delegateReadOr(address.getAddressSpace(), m -> m.getValueWithDefault(language, register, snap, address), () -> this.getDefaultValue(language, register, address));
    }

    @Override
    public AddressSetView getRegisterValueAddressRanges(Language language, Register register, long snap, AddressRange within) {
        return (AddressSetView)this.delegateRead(within.getAddressSpace(), m -> m.getRegisterValueAddressRanges(language, register, snap, within), new AddressSet());
    }

    @Override
    public AddressSetView getRegisterValueAddressRanges(Language language, Register register, long snap) {
        return this.delegateAddressSet(this.getActiveMemorySpaces(), m -> m.getRegisterValueAddressRanges(language, register, snap));
    }

    @Override
    public boolean hasRegisterValueInAddressRange(Language language, Register register, long snap, AddressRange within) {
        return this.delegateReadB(within.getAddressSpace(), m -> m.hasRegisterValueInAddressRange(language, register, snap, within), false);
    }

    @Override
    public boolean hasRegisterValue(Language language, Register register, long snap) {
        return this.delegateAny(this.getActiveMemorySpaces(), m -> m.hasRegisterValue(language, register, snap));
    }

    @Override
    public void clear(Range<Long> span, AddressRange range) {
        this.delegateDeleteV(range.getAddressSpace(), m -> m.clear(span, range));
    }

    @DBAnnotatedObjectInfo(version=0)
    protected static class DBTraceRegisterContextEntry
    extends DBTraceAddressSnapRangePropertyMapTree.AbstractDBTraceAddressSnapRangePropertyMapData<byte[]> {
        static final String VALUE_COLUMN_NAME = "Value";
        @DBAnnotatedColumn(value="Value")
        static DBObjectColumn VALUE_COLUMN;
        @DBAnnotatedField(column="Value")
        private byte[] value;

        public DBTraceRegisterContextEntry(DBTraceAddressSnapRangePropertyMapTree<byte[], ?> tree, DBCachedObjectStore<?> store, DBRecord record) {
            super(tree, store, record);
        }

        protected void setRecordValue(byte[] value) {
            this.value = value;
            this.update(VALUE_COLUMN);
        }

        protected byte[] getRecordValue() {
            return this.value;
        }

        void setLifespan(Range<Long> lifespan) {
            super.doSetLifespan(lifespan);
        }
    }
}

