/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.bookmark;

import ghidra.trace.database.bookmark.DBTraceBookmarkManager;
import ghidra.trace.model.bookmark.TraceBookmark;
import ghidra.trace.model.bookmark.TraceBookmarkType;
import ghidra.util.LockHold;
import java.awt.Color;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.locks.Lock;
import javax.swing.ImageIcon;

public class DBTraceBookmarkType
implements TraceBookmarkType {
    static int nextId = 1;
    protected final DBTraceBookmarkManager manager;
    protected final String name;
    protected ImageIcon icon;
    protected Color color;
    protected int priority;
    protected final int id = DBTraceBookmarkType.nextId();
    protected final Collection<TraceBookmark> bookmarkView;

    static synchronized int nextId() {
        return nextId++;
    }

    public DBTraceBookmarkType(DBTraceBookmarkManager manager, String name, ImageIcon icon, Color color, int priority) {
        this.manager = manager;
        this.name = name;
        this.icon = icon;
        this.color = color;
        this.priority = priority;
        this.bookmarkView = Collections.unmodifiableCollection(manager.getBookmarksByType(name));
    }

    public DBTraceBookmarkType(DBTraceBookmarkManager manager, String name) {
        this(manager, name, null, null, -1);
    }

    public String getTypeString() {
        return this.name;
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public Color getMarkerColor() {
        return this.color;
    }

    public int getMarkerPriority() {
        return this.priority;
    }

    public int getTypeId() {
        return this.id;
    }

    @Override
    public void setIcon(ImageIcon icon) {
        this.icon = icon;
    }

    @Override
    public void setMarkerColor(Color color) {
        this.color = color;
    }

    @Override
    public void setMarkerPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public Collection<String> getCategories() {
        try (LockHold hold = LockHold.lock((Lock)this.manager.getLock().readLock());){
            HashSet<String> result = new HashSet<String>();
            for (TraceBookmark bm : this.bookmarkView) {
                result.add(bm.getCategory());
            }
            HashSet<String> hashSet = result;
            return hashSet;
        }
    }

    public boolean hasBookmarks() {
        return !this.bookmarkView.isEmpty();
    }

    @Override
    public int countBookmarks() {
        return this.bookmarkView.size();
    }

    @Override
    public Collection<TraceBookmark> getBookmarks() {
        return this.bookmarkView;
    }
}

