/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.bookmark;

import com.google.common.collect.Range;
import db.DBHandle;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.trace.database.DBTrace;
import ghidra.trace.database.bookmark.DBTraceBookmark;
import ghidra.trace.database.bookmark.DBTraceBookmarkRegisterSpace;
import ghidra.trace.database.bookmark.DBTraceBookmarkSpace;
import ghidra.trace.database.bookmark.DBTraceBookmarkType;
import ghidra.trace.database.map.DBTraceAddressSnapRangePropertyMapTree;
import ghidra.trace.database.space.AbstractDBTraceSpaceBasedManager;
import ghidra.trace.database.space.DBTraceDelegatingManager;
import ghidra.trace.database.space.DBTraceSpaceKey;
import ghidra.trace.database.thread.DBTraceThread;
import ghidra.trace.database.thread.DBTraceThreadManager;
import ghidra.trace.model.Trace;
import ghidra.trace.model.bookmark.TraceBookmarkManager;
import ghidra.trace.model.bookmark.TraceBookmarkType;
import ghidra.trace.model.stack.TraceStackFrame;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.util.TraceChangeRecord;
import ghidra.util.LockHold;
import ghidra.util.Msg;
import ghidra.util.database.DBOpenMode;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import javax.swing.ImageIcon;

public class DBTraceBookmarkManager
extends AbstractDBTraceSpaceBasedManager<DBTraceBookmarkSpace, DBTraceBookmarkRegisterSpace>
implements TraceBookmarkManager,
DBTraceDelegatingManager<DBTraceBookmarkSpace> {
    public static final String NAME = "Bookmark";
    protected static final int SPACE_ID_MASK = 4095;
    protected static final int SPACE_ID_SHIFT = 52;
    protected static final long MEM_KEY_MASK = 0xFFFFFFFFFFFFFL;
    protected static final int MEM_KEY_SHIFT = 0;
    protected static final long REG_THREAD_MASK = 0xFFFFFFFFL;
    protected static final int REG_THREAD_SHIFT = 20;
    protected static final long REG_FRAME_MASK = 255L;
    protected static final int REG_FRAME_SHIFT = 12;
    protected static final long REG_KEY_MASK = 4095L;
    protected static final int REG_KEY_SHIFT = 0;
    protected final Map<String, DBTraceBookmarkType> typesByName = new HashMap<String, DBTraceBookmarkType>();
    protected final Collection<DBTraceBookmarkType> typesView = Collections.unmodifiableCollection(this.typesByName.values());

    protected static long packId(long key, DBTraceSpaceKey spaceKey) {
        return spaceKey.getAddressSpace().isRegisterSpace() ? DBTraceBookmarkManager.packRegId(key, spaceKey) : DBTraceBookmarkManager.packMemId(key, spaceKey);
    }

    protected static long packMemId(long key, DBTraceSpaceKey spaceKey) {
        long spaceId = spaceKey.getAddressSpace().getSpaceID();
        assert (spaceKey.getThread() == null);
        if ((spaceId & 0xFFFL) != spaceId) {
            throw new AssertionError((Object)"Bad assumption");
        }
        if ((key & 0xFFFFFFFFFFFFFL) != key) {
            throw new AssertionError((Object)"Bad assumption");
        }
        return spaceId << 52 | key << 0;
    }

    protected static long packRegId(long key, DBTraceSpaceKey spaceKey) {
        long spaceId = spaceKey.getAddressSpace().getSpaceID();
        long threadKey = spaceKey.getThread().getKey();
        int frameLevel = spaceKey.getFrameLevel();
        if ((spaceId & 0xFFFL) != spaceId) {
            throw new AssertionError((Object)"Bad assumption");
        }
        if ((threadKey & 0xFFFFFFFFL) != threadKey) {
            throw new AssertionError((Object)"Bad assumption");
        }
        if (((long)frameLevel & 0xFFL) != (long)frameLevel) {
            throw new AssertionError((Object)"Bad assumption");
        }
        if ((key & 0xFFFL) != key) {
            throw new AssertionError((Object)"Bad assumption");
        }
        return spaceId << 52 | threadKey << 20 | (long)(frameLevel << 12) | key << 0;
    }

    protected static int unpackSpaceId(long id) {
        return (int)(id >> 52 & 0xFFFL);
    }

    protected static long unpackMemKey(long id) {
        return id >> 0 & 0xFFFFFFFFFFFFFL;
    }

    protected static long unpackRegThread(long id) {
        return id >> 20 & 0xFFFFFFFFL;
    }

    protected static int unpackRegFrame(long id) {
        return (int)(id >> 12 & 0xFFL);
    }

    protected static long unpackRegKey(long id) {
        return id >> 0 & 0xFFFL;
    }

    protected static DBTraceSpaceKey unpackSpaceKey(long id, Language baseLanguage, DBTraceThreadManager threadManager) {
        int spaceId = DBTraceBookmarkManager.unpackSpaceId(id);
        AddressSpace space = baseLanguage.getAddressFactory().getAddressSpace(spaceId);
        if (space == null) {
            return null;
        }
        return space.isRegisterSpace() ? DBTraceBookmarkManager.unpackRegSpaceKey(space, threadManager, id) : DBTraceBookmarkManager.unpackMemSpaceKey(space, id);
    }

    protected static DBTraceSpaceKey unpackMemSpaceKey(AddressSpace space, long id) {
        return DBTraceSpaceKey.create(space, null, 0);
    }

    protected static DBTraceSpaceKey unpackRegSpaceKey(AddressSpace space, DBTraceThreadManager threadManager, long id) {
        long threadKey = DBTraceBookmarkManager.unpackRegThread(id);
        DBTraceThread thread = threadManager.getThread(threadKey);
        assert (thread != null);
        int frameLevel = DBTraceBookmarkManager.unpackRegFrame(id);
        return DBTraceSpaceKey.create(space, thread, frameLevel);
    }

    public DBTraceBookmarkManager(DBHandle dbh, DBOpenMode openMode, ReadWriteLock lock, TaskMonitor monitor, Language baseLanguage, DBTrace trace, DBTraceThreadManager threadManager) throws VersionException, IOException {
        super(NAME, dbh, openMode, lock, monitor, baseLanguage, trace, threadManager);
        this.loadSpaces();
    }

    @Override
    protected DBTraceBookmarkSpace createSpace(AddressSpace space, AbstractDBTraceSpaceBasedManager.DBTraceSpaceEntry ent) throws VersionException, IOException {
        return new DBTraceBookmarkSpace(this, space);
    }

    @Override
    protected DBTraceBookmarkRegisterSpace createRegisterSpace(AddressSpace space, DBTraceThread thread, AbstractDBTraceSpaceBasedManager.DBTraceSpaceEntry ent) throws VersionException, IOException {
        return new DBTraceBookmarkRegisterSpace(this, space, thread, ent.getFrameLevel());
    }

    @Override
    public DBTraceBookmarkSpace getBookmarkSpace(AddressSpace space, boolean createIfAbsent) {
        return this.getForSpace(space, createIfAbsent);
    }

    @Override
    public DBTraceBookmarkRegisterSpace getBookmarkRegisterSpace(TraceThread thread, boolean createIfAbsent) {
        return (DBTraceBookmarkRegisterSpace)this.getForRegisterSpace(thread, 0, createIfAbsent);
    }

    @Override
    public DBTraceBookmarkRegisterSpace getBookmarkRegisterSpace(TraceStackFrame frame, boolean createIfAbsent) {
        return (DBTraceBookmarkRegisterSpace)this.getForRegisterSpace(frame, createIfAbsent);
    }

    @Override
    public DBTraceBookmarkSpace getForSpace(AddressSpace space, boolean createIfAbsent) {
        return (DBTraceBookmarkSpace)super.getForSpace(space, createIfAbsent);
    }

    @Override
    public Lock readLock() {
        return this.lock.readLock();
    }

    @Override
    public Lock writeLock() {
        return this.lock.writeLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBTraceBookmarkType getOrDefineBookmarkType(String typeName) {
        DBTraceBookmarkType type;
        DBTraceBookmarkManager dBTraceBookmarkManager = this;
        synchronized (dBTraceBookmarkManager) {
            type = this.typesByName.get(typeName);
            if (type != null) {
                return type;
            }
            Msg.warn((Object)this, (Object)("Created default bookmark type: " + typeName));
            type = new DBTraceBookmarkType(this, typeName);
            this.typesByName.put(typeName, type);
        }
        this.trace.setChanged(new TraceChangeRecord<DBTraceBookmarkType, Void>(Trace.TraceBookmarkChangeType.TYPE_ADDED, null, type));
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized DBTraceBookmarkType defineBookmarkType(String typeName, ImageIcon icon, Color color, int priority) {
        DBTraceBookmarkType type;
        DBTraceBookmarkManager dBTraceBookmarkManager = this;
        synchronized (dBTraceBookmarkManager) {
            type = this.typesByName.get(typeName);
            if (type != null) {
                type.icon = icon;
                type.color = color;
                type.priority = priority;
                return type;
            }
            type = new DBTraceBookmarkType(this, typeName, icon, color, priority);
            this.typesByName.put(typeName, type);
        }
        this.trace.setChanged(new TraceChangeRecord<DBTraceBookmarkType, Void>(Trace.TraceBookmarkChangeType.TYPE_ADDED, null, type));
        return type;
    }

    public Collection<? extends DBTraceBookmarkType> getDefinedBookmarkTypes() {
        return this.typesView;
    }

    @Override
    public synchronized DBTraceBookmarkType getBookmarkType(String typeName) {
        return this.typesByName.get(typeName);
    }

    @Override
    public DBTraceBookmark getBookmark(long id) {
        try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
            DBTraceSpaceKey spaceKey = DBTraceBookmarkManager.unpackSpaceKey(id, this.baseLanguage, this.threadManager);
            if (spaceKey == null) {
                DBTraceBookmark dBTraceBookmark = null;
                return dBTraceBookmark;
            }
            DBTraceBookmarkSpace space = (DBTraceBookmarkSpace)this.get(spaceKey, false);
            if (space == null) {
                DBTraceBookmark dBTraceBookmark = null;
                return dBTraceBookmark;
            }
            long bookmarkKey = spaceKey.getAddressSpace().isRegisterSpace() ? DBTraceBookmarkManager.unpackRegKey(id) : DBTraceBookmarkManager.unpackMemKey(id);
            DBTraceBookmark dBTraceBookmark = space.bookmarkMapSpace.getDataByKey(bookmarkKey);
            return dBTraceBookmark;
        }
    }

    public Collection<DBTraceBookmark> getBookmarksByType(String typeName) {
        return this.delegateCollection(this.getActiveSpaces(), m -> m.getBookmarksByType(typeName));
    }

    @Override
    public Set<String> getCategoriesForType(TraceBookmarkType type) {
        return this.delegateHashSet(this.getActiveMemorySpaces(), m -> m.getCategoriesForType(type));
    }

    @Override
    public DBTraceBookmark addBookmark(Range<Long> lifespan, Address address, TraceBookmarkType type, String category, String comment) {
        return (DBTraceBookmark)this.delegateWrite(address.getAddressSpace(), m -> m.addBookmark((Range)lifespan, address, type, category, comment));
    }

    public Collection<? extends DBTraceBookmark> getAllBookmarks() {
        return this.delegateCollection(this.getActiveMemorySpaces(), m -> m.getAllBookmarks());
    }

    public Iterable<? extends DBTraceBookmark> getBookmarksAt(long snap, Address address) {
        return (Iterable)this.delegateRead(address.getAddressSpace(), m -> m.getBookmarksAt(snap, address), Set.of());
    }

    public Iterable<? extends DBTraceBookmark> getBookmarksEnclosed(Range<Long> lifespan, AddressRange range) {
        return (Iterable)this.delegateRead(range.getAddressSpace(), m -> m.getBookmarksEnclosed(lifespan, range), Set.of());
    }

    public Iterable<? extends DBTraceBookmark> getBookmarksIntersecting(Range<Long> lifespan, AddressRange range) {
        return (Iterable)this.delegateRead(range.getAddressSpace(), m -> m.getBookmarksIntersecting(lifespan, range), Set.of());
    }

    public Collection<? extends DBTraceBookmark> getBookmarksAdded(long from, long to) {
        if (from == to) {
            return Collections.emptySet();
        }
        ArrayList result = new ArrayList();
        for (DBTraceBookmarkSpace space : this.memSpaces.values()) {
            result.addAll(space.bookmarkMapSpace.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.added(from, to, space.getAddressSpace())).values());
        }
        return result;
    }

    public Collection<? extends DBTraceBookmark> getBookmarksRemoved(long from, long to) {
        if (from == to) {
            return Collections.emptySet();
        }
        ArrayList result = new ArrayList();
        for (DBTraceBookmarkSpace space : this.memSpaces.values()) {
            result.addAll(space.bookmarkMapSpace.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.removed(from, to, space.getAddressSpace())).values());
        }
        return result;
    }
}

