/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.table.field;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.CodeUnitFormatOptions;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.OffsetReference;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ShiftedReference;
import ghidra.program.model.symbol.Symbol;
import ghidra.util.SystemUtilities;

public class AddressBasedLocation
implements Comparable<AddressBasedLocation> {
    private final Address address;
    private Class<? extends Reference> referenceClass;
    private final String stringRepresentation;

    public AddressBasedLocation() {
        this(null, "<NULL>");
    }

    public AddressBasedLocation(Program program, Address address) {
        this(address, AddressBasedLocation.buildStringRepresentation(program, address, null, CodeUnitFormatOptions.ShowBlockName.NEVER));
    }

    public AddressBasedLocation(Program program, Reference reference, CodeUnitFormatOptions.ShowBlockName showBlockName) {
        this(reference.getToAddress(), AddressBasedLocation.buildStringRepresentation(program, reference.getToAddress(), reference, showBlockName));
        this.referenceClass = reference.getClass();
    }

    protected AddressBasedLocation(Address address, String representation) {
        this.address = address;
        this.stringRepresentation = representation;
    }

    public Address getAddress() {
        return this.address;
    }

    public boolean isMemoryLocation() {
        return this.address != null && this.address.isMemoryAddress();
    }

    private static String buildStringRepresentation(Program program, Address address, Reference reference, CodeUnitFormatOptions.ShowBlockName showBlockName) {
        Object addrStr;
        if (address == null) {
            return "<NULL>";
        }
        if (address.getAddressSpace().getType() == 15) {
            return "";
        }
        if (address.isExternalAddress()) {
            return AddressBasedLocation.getExternalAddressRepresentation(program, address);
        }
        if (address.isVariableAddress()) {
            return AddressBasedLocation.getVariableAddressRepresentation();
        }
        if (address.isStackAddress()) {
            return AddressBasedLocation.getStackAddressRepresentation(address);
        }
        if (address.isConstantAddress()) {
            return AddressBasedLocation.getConstantAddressRepresentation(address);
        }
        if (AddressBasedLocation.isRegisterAddress(program, address)) {
            return AddressBasedLocation.getRegisterAddressRepresentation(program, address);
        }
        if (reference != null && reference.isOffsetReference()) {
            OffsetReference offsetRef = (OffsetReference)reference;
            long offset = offsetRef.getOffset();
            boolean neg = offset < 0L;
            Address baseAddr = offsetRef.getBaseAddress();
            addrStr = baseAddr.toString() + (neg ? "-" : "+") + "0x" + Long.toHexString(neg ? -offset : offset);
        } else if (reference != null && reference.isShiftedReference()) {
            ShiftedReference shiftedRef = (ShiftedReference)reference;
            StringBuilder buf = new StringBuilder();
            buf.append(address.toString());
            buf.append("(0x");
            buf.append(Long.toHexString(shiftedRef.getValue()));
            buf.append("<<");
            buf.append(Long.toString(shiftedRef.getShift()));
            buf.append(")");
            addrStr = buf.toString();
        } else {
            addrStr = address.toString();
        }
        if (showBlockName != CodeUnitFormatOptions.ShowBlockName.NEVER) {
            Memory mem = program.getMemory();
            MemoryBlock toBlock = mem.getBlock(address);
            if (toBlock != null && showBlockName == CodeUnitFormatOptions.ShowBlockName.NON_LOCAL && reference != null && toBlock.equals(mem.getBlock(reference.getFromAddress()))) {
                toBlock = null;
            }
            if (toBlock != null) {
                addrStr = toBlock.getName() + "::" + (String)addrStr;
            }
        }
        return addrStr;
    }

    private static boolean isRegisterAddress(Program program, Address address) {
        if (!address.isRegisterAddress()) {
            return false;
        }
        Register register = program.getRegister(address);
        return register != null;
    }

    private static String getExternalAddressRepresentation(Program program, Address address) {
        Symbol symbol = program.getSymbolTable().getPrimarySymbol(address);
        if (symbol == null) {
            return "External[ BAD ]";
        }
        ExternalLocation extLoc = program.getExternalManager().getExternalLocation(symbol);
        Address extAddr = extLoc.getAddress();
        if (extAddr != null) {
            return "External[" + extAddr.toString() + "]";
        }
        return "External[ ? ]";
    }

    private static String getRegisterAddressRepresentation(Program program, Address address) {
        Register register = program.getRegister(address);
        String regName = register.getName();
        return "Register[" + regName + "]";
    }

    private static String getStackAddressRepresentation(Address address) {
        int offset = (int)address.getOffset();
        boolean neg = offset < 0;
        return "Stack[" + (neg ? "-" : "+") + "0x" + Integer.toHexString(neg ? -offset : offset) + "]";
    }

    private static String getConstantAddressRepresentation(Address address) {
        int offset = (int)address.getOffset();
        boolean neg = offset < 0;
        return "Constant[" + (neg ? "-" : "+") + "0x" + Integer.toHexString(neg ? -offset : offset) + "]";
    }

    private static String getVariableAddressRepresentation() {
        return "<VARIABLE>";
    }

    public boolean isReferenceDestination() {
        return this.referenceClass != null;
    }

    public boolean isShiftedAddress() {
        return this.referenceClass != null && ShiftedReference.class.isAssignableFrom(this.referenceClass);
    }

    public boolean isOffsetAddress() {
        return this.referenceClass != null && OffsetReference.class.isAssignableFrom(this.referenceClass);
    }

    public String toString() {
        return this.stringRepresentation;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AddressBasedLocation)) {
            return false;
        }
        AddressBasedLocation otherLocation = (AddressBasedLocation)obj;
        if (SystemUtilities.isEqual((Object)this.address, (Object)otherLocation.address)) {
            return this.stringRepresentation.equals(otherLocation.stringRepresentation);
        }
        return false;
    }

    public int hashCode() {
        int hashCode = this.address != null ? this.address.hashCode() : 0;
        return hashCode ^= this.stringRepresentation.hashCode();
    }

    private int compareAddressSameSpace(AddressBasedLocation otherLocation) {
        if (this.address.isExternalAddress() || this.address.isVariableAddress() || this.address.isRegisterAddress()) {
            return this.stringRepresentation.compareTo(otherLocation.stringRepresentation);
        }
        int rc = this.address.compareTo((Object)otherLocation.address);
        if (rc == 0) {
            if (this.isShiftedAddress()) {
                rc = otherLocation.isOffsetAddress() ? -1 : (otherLocation.isShiftedAddress() ? this.stringRepresentation.compareTo(otherLocation.stringRepresentation) : 1);
            } else if (this.isOffsetAddress()) {
                if (!otherLocation.isOffsetAddress()) {
                    rc = 1;
                }
            } else if (otherLocation.isOffsetAddress() || otherLocation.isShiftedAddress()) {
                rc = -1;
            }
        }
        return rc;
    }

    @Override
    public int compareTo(AddressBasedLocation otherLocation) {
        Address otherAddress = otherLocation.address;
        if (this.address == null) {
            if (otherAddress == null) {
                return 0;
            }
            return -1;
        }
        if (otherAddress == null) {
            return 1;
        }
        AddressSpace mySpace = this.address.getAddressSpace();
        AddressSpace otherSpace = otherAddress.getAddressSpace();
        int rc = mySpace.getName().compareTo(otherSpace.getName());
        if (rc != 0) {
            return rc;
        }
        return this.compareAddressSameSpace(otherLocation);
    }
}

