/*
 * Decompiled with CFR 0.152.
 */
package ghidra.plugins.importer.batch;

import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.opinion.BinaryLoader;
import ghidra.app.util.opinion.Loader;
import ghidra.app.util.opinion.LoaderMap;
import ghidra.app.util.opinion.LoaderService;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.formats.gfilesystem.FileSystemProbeConflictResolver;
import ghidra.formats.gfilesystem.FileSystemRef;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.formats.gfilesystem.RefdFile;
import ghidra.formats.gfilesystem.crypto.CryptoSession;
import ghidra.plugins.importer.batch.BatchGroup;
import ghidra.plugins.importer.batch.BatchSegregatingCriteria;
import ghidra.plugins.importer.batch.UserAddedSourceInfo;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.CryptoException;
import ghidra.util.task.MonitoredRunnable;
import ghidra.util.task.TaskBuilder;
import ghidra.util.task.TaskMonitor;
import ghidra.util.task.WrappingTaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class BatchInfo {
    public static final int MAXDEPTH_UNLIMITED = -1;
    public static final int MAXDEPTH_DEFAULT = 2;
    private FileSystemService fsService = FileSystemService.getInstance();
    private Map<BatchSegregatingCriteria, BatchGroup> groupsByCriteria = Collections.synchronizedMap(new HashMap());
    private Set<FSRL> userAddedFSRLs = Collections.synchronizedSet(new HashSet());
    private List<UserAddedSourceInfo> userAddedSources = Collections.synchronizedList(new ArrayList());
    private int maxDepth;
    private UserAddedSourceInfo currentUASI;

    public BatchInfo() {
        this(2);
    }

    public BatchInfo(int maxDepth) {
        this.maxDepth = maxDepth;
    }

    public List<BatchGroup> getGroups() {
        return new ArrayList<BatchGroup>(this.groupsByCriteria.values());
    }

    public int getTotalCount() {
        int count = 0;
        for (BatchGroup batchGroup : this.groupsByCriteria.values()) {
            count += batchGroup.getBatchLoadConfig().size();
        }
        return count;
    }

    public int getTotalRawCount() {
        int count = 0;
        for (UserAddedSourceInfo uasi : this.userAddedSources) {
            count += uasi.getRawFileCount();
        }
        return count;
    }

    public int getEnabledCount() {
        int count = 0;
        for (BatchGroup batchGroup : this.groupsByCriteria.values()) {
            if (!batchGroup.isEnabled()) continue;
            count += batchGroup.getBatchLoadConfig().size();
        }
        return count;
    }

    public void remove(FSRL fsrl) {
        Iterator<Object> iterator = this.groupsByCriteria.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<BatchSegregatingCriteria, BatchGroup> entry = iterator.next();
            BatchGroup bg = entry.getValue();
            bg.removeDescendantsOf(fsrl);
            if (!bg.isEmpty()) continue;
            iterator.remove();
        }
        iterator = this.userAddedSources.iterator();
        while (iterator.hasNext()) {
            UserAddedSourceInfo uasi = (UserAddedSourceInfo)iterator.next();
            if (!uasi.getFSRL().equals(fsrl)) continue;
            iterator.remove();
        }
        this.userAddedFSRLs.remove(fsrl);
    }

    public boolean addFile(FSRL fsrl, TaskMonitor taskMonitor) throws IOException, CancelledException {
        if (this.userAddedFSRLs.contains(fsrl = this.fsService.getFullyQualifiedFSRL(fsrl, taskMonitor))) {
            throw new IOException("Batch already contains file " + fsrl);
        }
        this.currentUASI = new UserAddedSourceInfo(fsrl);
        this.userAddedSources.add(this.currentUASI);
        this.userAddedFSRLs.add(this.currentUASI.getFSRL());
        int startCount = this.getTotalCount();
        boolean result = this.doAddFile(fsrl, taskMonitor);
        int endCount = this.getTotalCount();
        this.currentUASI.setFileCount(endCount - startCount);
        return result;
    }

    private boolean doAddFile(FSRL fsrl, TaskMonitor taskMonitor) throws IOException, CancelledException {
        try (RefdFile refdFile = this.fsService.getRefdFile(fsrl, taskMonitor);){
            GFile file = refdFile.file;
            if (file.isDirectory()) {
                this.processFS(file.getFilesystem(), file, taskMonitor);
                boolean bl = true;
                return bl;
            }
            if (this.processAsFS(fsrl, taskMonitor)) {
                boolean bl = true;
                return bl;
            }
            if (this.processWithLoader(fsrl, taskMonitor)) {
                boolean bl = true;
                return bl;
            }
            this.fsService.releaseFileCache(fsrl);
            boolean bl = false;
            return bl;
        }
    }

    private boolean shouldTerminateRecurse(FSRL fsrl) {
        if (this.maxDepth <= 0) {
            return false;
        }
        int initialLevel = this.currentUASI.getFSRL().getNestingDepth();
        int fsrlLevel = fsrl.getNestingDepth();
        return fsrlLevel - initialLevel > this.maxDepth - 1;
    }

    public boolean wasRecurseTerminatedEarly() {
        for (UserAddedSourceInfo uasi : this.userAddedSources) {
            if (!uasi.wasRecurseTerminatedEarly()) continue;
            return true;
        }
        return false;
    }

    public boolean isSingleApp() {
        HashSet<String> foundLoaders = new HashSet<String>();
        for (BatchGroup group : this.groupsByCriteria.values()) {
            for (BatchGroup.BatchLoadConfig batchLoadConfig : group.getBatchLoadConfig()) {
                String loaderID = batchLoadConfig.getLoadSpecs().iterator().next().getLoader().getName();
                if (foundLoaders.add(loaderID)) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (BatchGroup similarApps : this.groupsByCriteria.values()) {
            sb.append(similarApps.toString());
            sb.append("\n");
        }
        return sb.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean processAsFS(FSRL fsrl, TaskMonitor taskMonitor) throws CancelledException {
        try (FileSystemRef fsRef = this.fsService.probeFileForFilesystem(fsrl, taskMonitor, FileSystemProbeConflictResolver.CHOOSEFIRST);){
            if (fsRef == null) {
                boolean bl = false;
                return bl;
            }
            GFileSystem fs = fsRef.getFilesystem();
            this.currentUASI.incContainerCount();
            if (this.shouldTerminateRecurse(fs.getFSRL())) {
                this.currentUASI.setRecurseTerminatedEarly(true);
                boolean bl = true;
                return bl;
            }
            this.currentUASI.setMaxNestLevel(Math.max(this.currentUASI.getMaxNestLevel(), fs.getFSRL().getNestingDepth()));
            this.processFS(fs, null, taskMonitor);
            boolean bl = true;
            return bl;
        }
        catch (IOException ioe) {
            Msg.warn((Object)this, (Object)("Error while probing file " + fsrl + " for filesystems: " + ioe.getMessage()));
            return false;
        }
    }

    private void processFS(GFileSystem fs, GFile startDir, TaskMonitor taskMonitor) throws CancelledException, IOException {
        for (GFile file : FSUtilities.listFileSystem(fs, startDir, null, taskMonitor)) {
            FSRL fqFSRL;
            taskMonitor.checkCanceled();
            try {
                fqFSRL = this.fsService.getFullyQualifiedFSRL(file.getFSRL(), taskMonitor);
            }
            catch (IOException e) {
                Msg.warn((Object)this, (Object)("Error getting info for " + file.getFSRL()));
                continue;
            }
            this.doAddFile(fqFSRL, taskMonitor);
            this.currentUASI.incRawFileCount();
        }
    }

    private boolean processWithLoader(FSRL fsrl, TaskMonitor monitor) throws IOException, CancelledException {
        boolean bl;
        block10: {
            ByteProvider provider = this.fsService.getByteProvider(fsrl, false, monitor);
            try {
                LoaderMap loaderMap = this.pollLoadersForLoadSpecs(provider, fsrl, monitor);
                for (Loader loader : loaderMap.keySet()) {
                    Collection loadSpecs;
                    BatchSegregatingCriteria bsc = new BatchSegregatingCriteria(loader, loadSpecs = (Collection)loaderMap.get(loader), provider);
                    BatchGroup batchGroup = this.groupsByCriteria.get(bsc);
                    if (batchGroup == null) {
                        batchGroup = new BatchGroup(bsc);
                        this.groupsByCriteria.put(bsc, batchGroup);
                    }
                    batchGroup.add(provider, loadSpecs, fsrl, this.currentUASI);
                }
                boolean bl2 = bl = loaderMap.keySet().size() > 0;
                if (provider == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (provider != null) {
                        try {
                            provider.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ioe) {
                    Msg.warn((Object)this, (Object)("Error while probing file " + fsrl + " for loader applications: " + ioe.getMessage()));
                    return false;
                }
            }
            provider.close();
        }
        return bl;
    }

    private LoaderMap pollLoadersForLoadSpecs(ByteProvider provider, FSRL fsrl, TaskMonitor monitor) {
        monitor.setMessage(fsrl.getName());
        return LoaderService.getSupportedLoadSpecs(provider, loader -> !(loader instanceof BinaryLoader));
    }

    public List<UserAddedSourceInfo> getUserAddedSources() {
        return this.userAddedSources;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public void setMaxDepth(int newMaxDepth) {
        new TaskBuilder("Scanning Source Files", monitor -> this.doSetMaxDepth(newMaxDepth, monitor)).setStatusTextAlignment(10).setHasProgress(false).launchModal();
    }

    List<FSRL> addFiles(List<FSRL> filesToAdd) {
        AddFilesRunnable runnable = new AddFilesRunnable(filesToAdd);
        new TaskBuilder("Adding Source Files", (MonitoredRunnable)runnable).setStatusTextAlignment(10).setHasProgress(false).launchModal();
        return runnable.getBadFiles();
    }

    private void doSetMaxDepth(int newMaxDepth, TaskMonitor monitor) {
        if (newMaxDepth == this.maxDepth) {
            return;
        }
        Msg.trace((Object)this, (Object)("Switching maxDepth from " + this.maxDepth + " to " + newMaxDepth));
        List<FSRL> files = this.userAddedSources.stream().map(source -> source.getFSRL()).collect(Collectors.toList());
        this.groupsByCriteria.clear();
        this.userAddedSources.clear();
        this.userAddedFSRLs.clear();
        this.maxDepth = newMaxDepth;
        this.doAddFiles(files, monitor);
    }

    private List<FSRL> doAddFiles(List<FSRL> filesToAdd, TaskMonitor monitor) {
        BatchTaskMonitor batchMonitor = new BatchTaskMonitor(monitor);
        try (CryptoSession cryptoSession = this.fsService.newCryptoSession();){
            ArrayList<FSRL> badFiles = new ArrayList<FSRL>();
            for (FSRL fsrl : filesToAdd) {
                Msg.trace((Object)this, (Object)("Adding " + fsrl));
                batchMonitor.setPrefix("Processing " + fsrl.getName() + ": ");
                try {
                    monitor.checkCanceled();
                    this.addFile(fsrl, (TaskMonitor)batchMonitor);
                }
                catch (CryptoException ce) {
                    FSUtilities.displayException(this, null, "Error Adding File To Batch Import", "Error while adding " + fsrl.getName() + " to batch import", ce);
                }
                catch (IOException ioe) {
                    Msg.error((Object)this, (Object)("Error while adding " + fsrl.getName() + " to batch import"), (Throwable)ioe);
                    badFiles.add(fsrl);
                }
                catch (CancelledException e) {
                    Msg.debug((Object)this, (Object)("Cancelling Add File task while adding " + fsrl.getName()));
                }
            }
            ArrayList<FSRL> arrayList = badFiles;
            return arrayList;
        }
    }

    private class BatchTaskMonitor
    extends WrappingTaskMonitor {
        private String prefix;

        BatchTaskMonitor(TaskMonitor delegate) {
            super(delegate);
        }

        void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public void setMessage(String message) {
            super.setMessage(this.prefix + " " + message);
        }

        public void initialize(long max) {
        }

        public void setProgress(long value) {
        }
    }

    private class AddFilesRunnable
    implements MonitoredRunnable {
        private List<FSRL> files;
        private List<FSRL> badFiles;

        AddFilesRunnable(List<FSRL> files) {
            this.files = files;
        }

        public void monitoredRun(TaskMonitor monitor) {
            this.badFiles = BatchInfo.this.doAddFiles(this.files, monitor);
        }

        List<FSRL> getBadFiles() {
            return this.badFiles;
        }
    }
}

