/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.ubi;

import generic.continues.GenericFactory;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.ByteProviderWrapper;
import ghidra.app.util.bin.format.FactoryBundledWithBinaryReader;
import ghidra.app.util.bin.format.coff.CoffException;
import ghidra.app.util.bin.format.coff.archive.CoffArchiveHeader;
import ghidra.app.util.bin.format.coff.archive.CoffArchiveMemberHeader;
import ghidra.app.util.bin.format.macho.MachException;
import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.ubi.FatArch;
import ghidra.app.util.bin.format.ubi.UbiException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class FatHeader {
    public static final int FAT_MAGIC = -889275714;
    public static final int FAT_CIGAM = -1095041334;
    private int magic;
    private int nfat_arch;
    private List<FatArch> architectures = new ArrayList<FatArch>();
    private List<MachHeader> machHeaders = new ArrayList<MachHeader>();

    public static FatHeader createFatHeader(GenericFactory factory, ByteProvider provider) throws IOException, UbiException, MachException {
        FatHeader fatHeader = (FatHeader)factory.create(FatHeader.class, new Object[0]);
        fatHeader.initFatHeader(factory, provider);
        return fatHeader;
    }

    private void initFatHeader(GenericFactory factory, ByteProvider provider) throws IOException, UbiException, MachException {
        FactoryBundledWithBinaryReader reader = new FactoryBundledWithBinaryReader(factory, provider, false);
        this.magic = reader.readNextInt();
        if (this.magic != -889275714 && this.magic != -1095041334) {
            throw new UbiException("Invalid UBI file.");
        }
        this.nfat_arch = reader.readNextInt();
        if (this.nfat_arch > 4096 || this.nfat_arch < 0) {
            throw new UbiException("Invalid UBI file.");
        }
        for (int i = 0; i < this.nfat_arch; ++i) {
            this.architectures.add(FatArch.createFatArch(reader));
        }
        for (FatArch fatarch : this.architectures) {
            ByteProviderWrapper wrapper = new ByteProviderWrapper(provider, fatarch.getOffset(), fatarch.getSize());
            CoffArchiveHeader caf = null;
            try {
                caf = CoffArchiveHeader.read(wrapper, TaskMonitor.DUMMY);
            }
            catch (CoffException e) {
                throw new UbiException(e);
            }
            if (caf != null) {
                for (CoffArchiveMemberHeader camh : caf.getArchiveMemberHeaders()) {
                    wrapper = new ByteProviderWrapper(provider, (long)fatarch.getOffset() + camh.getPayloadOffset(), camh.getSize());
                    try {
                        this.machHeaders.add(MachHeader.createMachHeader(factory, wrapper));
                    }
                    catch (MachException machException) {}
                }
                continue;
            }
            this.machHeaders.add(MachHeader.createMachHeader(factory, wrapper));
        }
    }

    public int getMagic() {
        return this.magic;
    }

    public int getFatArchitectureCount() {
        return this.nfat_arch;
    }

    public List<FatArch> getArchitectures() {
        return this.architectures;
    }

    public List<MachHeader> getMachHeaders() {
        return this.machHeaders;
    }
}

