/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.ne;

import ghidra.app.util.bin.format.FactoryBundledWithBinaryReader;
import ghidra.app.util.bin.format.ne.SegmentRelocation;
import ghidra.util.Conv;
import java.io.IOException;
import java.util.ArrayList;

public class Segment {
    private static final short FLAG_DATA = 1;
    private static final short FLAG_ALLOC = 2;
    private static final short FLAG_LOADED = 4;
    private static final short FLAG_MOVEABLE = 16;
    private static final short FLAG_PURE = 32;
    private static final short FLAG_PRELOAD = 64;
    private static final short FLAG_EXE_ONLY = 128;
    private static final short FLAG_READ_ONLY = 128;
    private static final short FLAG_RELOC_INFO = 256;
    private static final short FLAG_DISCARD = 4096;
    private static final short FLAG_32BIT = 8192;
    private FactoryBundledWithBinaryReader reader;
    private int segmentID;
    private short offset;
    private short length;
    private short flagword;
    private short minAllocSize;
    private int offsetAlign;
    private short nRelocations;
    private SegmentRelocation[] relocations;

    Segment(FactoryBundledWithBinaryReader reader, short segmentAlignment, int segmentID) throws IOException {
        this.reader = reader;
        this.segmentID = segmentID;
        this.offset = reader.readNextShort();
        this.length = reader.readNextShort();
        this.flagword = reader.readNextShort();
        this.minAllocSize = reader.readNextShort();
        this.offsetAlign = Conv.shortToInt((short)this.offset) * Conv.shortToInt((short)segmentAlignment);
        ArrayList<SegmentRelocation> list = new ArrayList<SegmentRelocation>();
        if (this.hasRelocation()) {
            int relocPos = this.offsetAlign + Conv.shortToInt((short)this.length);
            long oldIndex = reader.getPointerIndex();
            reader.setPointerIndex(relocPos);
            this.nRelocations = reader.readNextShort();
            for (short i = 0; i < this.nRelocations; i = (short)(i + 1)) {
                list.add(new SegmentRelocation(reader, segmentID));
            }
            reader.setPointerIndex(oldIndex);
        }
        this.relocations = new SegmentRelocation[list.size()];
        list.toArray(this.relocations);
    }

    public int getSegmentID() {
        return this.segmentID;
    }

    public boolean is32bit() {
        return (this.flagword & 0x2000) != 0;
    }

    public boolean isCode() {
        return !this.isData();
    }

    public boolean isData() {
        return (this.flagword & 1) != 0;
    }

    public boolean hasRelocation() {
        return (this.flagword & 0x100) != 0;
    }

    public boolean isLoaderAllocated() {
        return (this.flagword & 2) != 0;
    }

    public boolean isLoaded() {
        return (this.flagword & 4) != 0;
    }

    public boolean isMoveable() {
        return (this.flagword & 0x10) != 0;
    }

    public boolean isPreload() {
        return (this.flagword & 0x40) != 0;
    }

    public boolean isPure() {
        return (this.flagword & 0x20) != 0;
    }

    public boolean isReadOnly() {
        return this.isData() && (this.flagword & 0x80) != 0;
    }

    public boolean isExecuteOnly() {
        return this.isCode() && (this.flagword & 0x80) != 0;
    }

    public boolean isDiscardable() {
        return (this.flagword & 0x1000) != 0;
    }

    public short getFlagword() {
        return this.flagword;
    }

    public short getLength() {
        return this.length;
    }

    public short getMinAllocSize() {
        return this.minAllocSize;
    }

    public short getOffset() {
        return this.offset;
    }

    public int getOffsetShiftAligned() {
        return this.offsetAlign;
    }

    public SegmentRelocation[] getRelocations() {
        return this.relocations;
    }

    public byte[] getBytes() throws IOException {
        int offset_int = this.getOffsetShiftAligned();
        int length_int = Conv.shortToInt((short)this.getLength());
        int minalloc_int = Conv.shortToInt((short)this.getMinAllocSize());
        if (minalloc_int == 0) {
            minalloc_int = 65536;
        }
        byte[] bytes = this.reader.readByteArray(offset_int, length_int);
        if (length_int >= minalloc_int) {
            return bytes;
        }
        byte[] newbytes = new byte[minalloc_int];
        System.arraycopy(bytes, 0, newbytes, 0, length_int);
        return newbytes;
    }
}

