/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macos.cfm;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.StructConverterUtil;
import ghidra.app.util.bin.format.macos.cfm.CFragLocatorKind;
import ghidra.app.util.bin.format.macos.cfm.CFragUsage;
import ghidra.app.util.bin.format.macos.cfm.CFragUsage1Union;
import ghidra.app.util.bin.format.macos.cfm.CFragUsage2Union;
import ghidra.app.util.bin.format.macos.cfm.CFragWhere1Union;
import ghidra.app.util.bin.format.macos.cfm.CFragWhere2Union;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.PascalString255DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class CFragResourceMember
implements StructConverter {
    public static final int kNullCFragVersion = 0;
    public static final int kWildcardCFragVersion = -1;
    private String architecture;
    private short reservedA;
    private byte reservedB;
    private byte updateLevel;
    private int currentVersion;
    private int oldDefVersion;
    private CFragUsage1Union uUsage1;
    private CFragUsage2Union uUsage2;
    private CFragUsage usage;
    private CFragLocatorKind where;
    private int offset;
    private int length;
    private CFragWhere1Union uWhere1;
    private CFragWhere2Union uWhere2;
    private short extensionCount;
    private short memberSize;
    private String name;

    public CFragResourceMember(BinaryReader reader) throws IOException {
        this.architecture = reader.readNextAsciiString(4);
        this.reservedA = reader.readNextShort();
        this.reservedB = reader.readNextByte();
        this.updateLevel = reader.readNextByte();
        this.currentVersion = reader.readNextInt();
        this.oldDefVersion = reader.readNextInt();
        this.uUsage1 = new CFragUsage1Union(reader);
        this.uUsage2 = new CFragUsage2Union(reader);
        this.usage = CFragUsage.get(reader);
        this.where = CFragLocatorKind.get(reader);
        this.offset = reader.readNextInt();
        this.length = reader.readNextInt();
        this.uWhere1 = new CFragWhere1Union(reader);
        this.uWhere2 = new CFragWhere2Union(reader);
        this.extensionCount = reader.readNextShort();
        this.memberSize = reader.readNextShort();
        int nameLength = reader.readNextByte() & 0xFF;
        this.name = reader.readNextAsciiString(nameLength);
        if (this.reservedA != 0 || this.reservedB != 0) {
            throw new IOException("Reserved fields contain invalid value(s).");
        }
    }

    public String getArchitecture() {
        return this.architecture;
    }

    public byte getUpdateLevel() {
        return this.updateLevel;
    }

    public int getCurrentVersion() {
        return this.currentVersion;
    }

    public int getOldDefVersion() {
        return this.oldDefVersion;
    }

    public CFragUsage1Union getUUsage1() {
        return this.uUsage1;
    }

    public CFragUsage2Union getUUsage2() {
        return this.uUsage2;
    }

    public CFragUsage getUsage() {
        return this.usage;
    }

    public CFragLocatorKind getWhere() {
        return this.where;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public CFragWhere1Union getUWhere1() {
        return this.uWhere1;
    }

    public CFragWhere2Union getUWhere2() {
        return this.uWhere2;
    }

    public int getExtensionCount() {
        return this.extensionCount;
    }

    public int getMemberSize() {
        return this.memberSize;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        String structName = StructConverterUtil.parseName(CFragResourceMember.class);
        StructureDataType struct = new StructureDataType(structName, 0);
        struct.add(STRING, 4, "architecture", null);
        struct.add(WORD, "reservedA", null);
        struct.add(BYTE, "reservedB", null);
        struct.add(BYTE, "updateLevel", null);
        struct.add(DWORD, "currentVersion", null);
        struct.add(DWORD, "oldDefVersion", null);
        struct.add(DWORD, "usage", this.usage.toString());
        struct.add(DWORD, "where", this.where.toString());
        struct.add(DWORD, "offset", null);
        struct.add(DWORD, "length", null);
        struct.add(BYTE, "reservedC", null);
        struct.add(BYTE, "reservedD", null);
        struct.add(DWORD, "extensionCount", null);
        struct.add(DWORD, "memberSize", null);
        struct.add((DataType)new PascalString255DataType(), this.name.length() + 1, "name", null);
        return struct;
    }
}

