/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf4.external;

import ghidra.app.util.bin.format.elf.GnuBuildIdSection;
import ghidra.app.util.bin.format.elf.GnuDebugLinkSection;
import ghidra.program.model.listing.Program;
import ghidra.util.NumericUtilities;

public class ExternalDebugInfo {
    private String filename;
    private int crc;
    private byte[] hash;

    public static ExternalDebugInfo fromProgram(Program program) {
        GnuDebugLinkSection.GnuDebugLinkSectionValues debugLinkValues = GnuDebugLinkSection.fromProgram(program);
        GnuBuildIdSection.GnuBuildIdValues buildIdValues = GnuBuildIdSection.fromProgram(program);
        if (buildIdValues != null && !buildIdValues.isValid()) {
            buildIdValues = null;
        }
        if (debugLinkValues == null && buildIdValues == null) {
            return null;
        }
        String filename = debugLinkValues != null ? debugLinkValues.getFilename() : null;
        int crc = debugLinkValues != null ? debugLinkValues.getCrc() : 0;
        byte[] hash = buildIdValues != null ? buildIdValues.getDescription() : null;
        return new ExternalDebugInfo(filename, crc, hash);
    }

    public ExternalDebugInfo(String filename, int crc, byte[] hash) {
        this.filename = filename;
        this.crc = crc;
        this.hash = hash;
    }

    public boolean hasFilename() {
        return this.filename != null && !this.filename.isBlank();
    }

    public String getFilename() {
        return this.filename;
    }

    public int getCrc() {
        return this.crc;
    }

    public byte[] getHash() {
        return this.hash;
    }

    public String toString() {
        return String.format("ExternalDebugInfo [filename=%s, crc=%s, hash=%s]", this.filename, Integer.toHexString(this.crc), NumericUtilities.convertBytesToString((byte[])this.hash));
    }
}

