/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf.line;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.dwarf4.LEB128;
import java.io.IOException;

public class FileEntry {
    private String fileName;
    private long directoryIndex;
    private long lastModifiedTime;
    private long fileLengthInBytes;

    FileEntry(BinaryReader reader) throws IOException {
        this.fileName = reader.readNextAsciiString();
        if (this.fileName.length() == 0) {
            return;
        }
        this.directoryIndex = LEB128.readAsLong(reader, false);
        this.lastModifiedTime = LEB128.readAsLong(reader, false);
        this.fileLengthInBytes = LEB128.readAsLong(reader, false);
    }

    public String getFileName() {
        return this.fileName;
    }

    public long getDirectoryIndex() {
        return this.directoryIndex;
    }

    public long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public long getFileLengthInBytes() {
        return this.fileLengthInBytes;
    }

    public String toString() {
        return this.fileName;
    }
}

