/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin;

import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.GhidraRandomAccessFile;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.util.Msg;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

@Deprecated(since="10.1", forRemoval=true)
public class RandomAccessByteProvider
implements ByteProvider {
    protected File file;
    protected GhidraRandomAccessFile randomAccessFile;
    private FSRL fsrl;
    private long fileLength;

    public RandomAccessByteProvider(File file) throws IOException {
        this(file, "r");
    }

    public RandomAccessByteProvider(File file, FSRL fsrl) throws IOException {
        this(file, fsrl, "r");
    }

    public RandomAccessByteProvider(File file, String permissions) throws IOException {
        this(file, null, permissions);
    }

    private RandomAccessByteProvider(File file, FSRL fsrl, String permissions) throws IOException {
        this.file = file;
        this.fsrl = fsrl;
        this.randomAccessFile = new GhidraRandomAccessFile(file, permissions);
        this.fileLength = this.randomAccessFile.length();
    }

    @Override
    public FSRL getFSRL() {
        return this.fsrl;
    }

    public void setFSRL(FSRL fsrl) {
        this.fsrl = fsrl;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public String getName() {
        return this.fsrl == null ? this.file.getName() : this.fsrl.getName();
    }

    @Override
    public String getAbsolutePath() {
        return this.fsrl == null ? this.file.getAbsolutePath() : this.fsrl.getPath();
    }

    @Override
    public InputStream getInputStream(long index) throws IOException {
        FileInputStream is = new FileInputStream(this.file);
        is.skip(index);
        return is;
    }

    @Override
    public void close() throws IOException {
        this.randomAccessFile.close();
    }

    @Override
    public long length() {
        return this.fileLength;
    }

    @Override
    public boolean isValidIndex(long index) {
        return 0L <= index && index < this.fileLength;
    }

    @Override
    public byte readByte(long index) throws IOException {
        this.randomAccessFile.seek(index);
        return this.randomAccessFile.readByte();
    }

    @Override
    public byte[] readBytes(long index, long length) throws IOException {
        byte[] b = new byte[(int)length];
        if (index > this.fileLength) {
            throw new EOFException("Invalid file offset " + index + " while reading " + this.file.getName());
        }
        if (index + length > this.fileLength) {
            Msg.trace((Object)this, (Object)("Read at EOF, can't return partial buffer, throwing IOException: " + this.file.getName()));
            throw new EOFException("EOF: unable to read " + length + " bytes at " + index);
        }
        this.randomAccessFile.seek(index);
        int nRead = this.randomAccessFile.read(b);
        if ((long)nRead != length) {
            throw new IOException("Unable to read " + length + " bytes");
        }
        return b;
    }

    public String toString() {
        return "RandomAccessByteProvider [\n  file=" + this.file + ",\n  fsrl=" + this.fsrl + ",\n  fileLength=" + this.fileLength + "\n]";
    }
}

