/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.services;

import ghidra.app.plugin.core.navigation.locationreferences.LocationReferenceContext;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.Function;

public class DataTypeReference {
    private DataType dataType;
    private String fieldName;
    private Function function;
    private Address address;
    private LocationReferenceContext context;

    public DataTypeReference(DataType dataType, String fieldName, Function function, Address address, LocationReferenceContext context) {
        this.dataType = dataType;
        this.fieldName = fieldName;
        this.function = function;
        this.address = address;
        this.context = context;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public Function getFunction() {
        return this.function;
    }

    public Address getAddress() {
        return this.address;
    }

    public LocationReferenceContext getContext() {
        return this.context;
    }

    public String toString() {
        String fieldNameText = this.fieldName == null ? "" : "\tfieldName: " + this.fieldName + "\n";
        return "{\n\tdataType: " + this.dataType.getName() + "\n" + fieldNameText + "\tfunction: " + this.function.getName() + "\n\taddress: " + this.address + "\n\tcontext: " + this.context + "\n}";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.address == null ? 0 : this.address.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataTypeReference other = (DataTypeReference)obj;
        return !(this.address == null ? other.address != null : !this.address.equals((Object)other.address));
    }
}

