/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.debug;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.ToolBarData;
import ghidra.app.events.ProgramActivatedPluginEvent;
import ghidra.app.plugin.debug.DbViewerProvider;
import ghidra.framework.data.DomainObjectAdapterDB;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.listing.Program;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import resources.Icons;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Developer", category="Testing", shortDescription="Show database tables", description="This plugin is a debug aid that allows the user to browse database tables.", eventsConsumed={ProgramActivatedPluginEvent.class})
public class DbViewerPlugin
extends Plugin {
    private DbViewerProvider viewer;
    private DockingAction refreshAction;

    public DbViewerPlugin(PluginTool tool) {
        super(tool);
        this.setupActions();
    }

    protected void dispose() {
        if (this.viewer != null) {
            this.deactivateViewer();
            this.tool.removeComponentProvider((ComponentProvider)this.viewer);
            this.viewer.dispose();
            this.viewer = null;
        }
        super.dispose();
    }

    private void setupActions() {
        this.refreshAction = new DockingAction("Refresh", this.getName()){

            public void actionPerformed(ActionContext context) {
                if (DbViewerPlugin.this.viewer != null) {
                    DbViewerPlugin.this.viewer.refresh();
                }
            }
        };
        this.refreshAction.setEnabled(false);
        ImageIcon icon = Icons.REFRESH_ICON;
        this.refreshAction.setToolBarData(new ToolBarData((Icon)icon));
    }

    private void activateViewer(DomainObjectAdapterDB dobj) {
        if (this.viewer == null) {
            this.viewer = new DbViewerProvider(this);
            this.tool.addComponentProvider((ComponentProvider)this.viewer, false);
            this.tool.addLocalAction((ComponentProvider)this.viewer, (DockingActionIf)this.refreshAction);
        }
        this.viewer.openDatabase(dobj.getName(), dobj.getDBHandle());
        this.refreshAction.setEnabled(true);
    }

    private void deactivateViewer() {
        if (this.viewer != null) {
            this.refreshAction.setEnabled(false);
            this.viewer.closeDatabase();
        }
    }

    public void processEvent(PluginEvent event) {
        if (event instanceof ProgramActivatedPluginEvent) {
            this.deactivateViewer();
            ProgramActivatedPluginEvent ev = (ProgramActivatedPluginEvent)event;
            Program currentProgram = ev.getActiveProgram();
            if (currentProgram instanceof DomainObjectAdapterDB) {
                this.activateViewer((DomainObjectAdapterDB)currentProgram);
            }
        }
    }
}

