/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.symtable;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.DockingUtils;
import docking.action.KeyBindingData;
import ghidra.app.context.ProgramActionContext;
import ghidra.app.context.ProgramSymbolActionContext;
import ghidra.app.plugin.core.symtable.SymbolFilter;
import ghidra.app.plugin.core.symtable.SymbolPanel;
import ghidra.app.plugin.core.symtable.SymbolRenderer;
import ghidra.app.plugin.core.symtable.SymbolTableModel;
import ghidra.app.plugin.core.symtable.SymbolTablePlugin;
import ghidra.app.util.SymbolInspector;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Symbol;
import ghidra.util.HelpLocation;
import ghidra.util.table.GhidraTable;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import resources.ResourceManager;

class SymbolProvider
extends ComponentProviderAdapter {
    private static final ImageIcon ICON = ResourceManager.loadImage((String)"images/table.png");
    private SymbolTablePlugin plugin;
    private SymbolRenderer renderer;
    private SymbolTableModel symbolKeyModel;
    private SymbolPanel symbolPanel;

    SymbolProvider(SymbolTablePlugin plugin) {
        super(plugin.getTool(), "Symbol Table", plugin.getName(), ProgramActionContext.class);
        this.plugin = plugin;
        this.setIcon(ICON);
        this.addToToolbar();
        this.setKeyBinding(new KeyBindingData(84, DockingUtils.CONTROL_KEY_MODIFIER_MASK));
        this.setHelpLocation(new HelpLocation(plugin.getName(), "Symbol_Table"));
        this.setWindowGroup("symbolTable");
        this.renderer = new SymbolRenderer();
        this.symbolKeyModel = new SymbolTableModel(this, plugin.getTool());
        this.symbolPanel = new SymbolPanel(this, this.symbolKeyModel, this.renderer, plugin.getTool(), plugin.getGoToService());
        this.addToTool();
    }

    void updateTitle() {
        this.setSubTitle(this.generateSubTitle());
    }

    public ActionContext getActionContext(MouseEvent event) {
        Program program = this.plugin.getProgram();
        if (program == null) {
            return null;
        }
        List<Symbol> symbols = this.symbolPanel.getSelectedSymbols();
        return new ProgramSymbolActionContext((ComponentProvider)this, program, symbols, (Component)((Object)this.getTable()));
    }

    void deleteSymbols() {
        List<Symbol> rowObjects = this.symbolPanel.getSelectedSymbols();
        this.symbolKeyModel.delete(rowObjects);
    }

    void setFilter() {
        this.symbolPanel.setFilter();
    }

    Symbol getCurrentSymbol() {
        List<Symbol> rowObjects = this.symbolPanel.getSelectedSymbols();
        if (rowObjects != null && rowObjects.size() >= 1) {
            return rowObjects.get(0);
        }
        return null;
    }

    Symbol getSymbolForRow(int row) {
        return (Symbol)this.symbolKeyModel.getRowObject(row);
    }

    void setCurrentSymbol(Symbol symbol) {
        this.plugin.getReferenceProvider().setCurrentSymbol(symbol);
    }

    Symbol getSymbol(long id) {
        return this.symbolKeyModel.getSymbol(id);
    }

    void dispose() {
        this.symbolKeyModel.dispose();
        this.symbolPanel.dispose();
        this.plugin = null;
    }

    void reload() {
        if (this.isVisible()) {
            this.symbolKeyModel.reload();
        }
    }

    void symbolAdded(Symbol s) {
        if (this.isVisible()) {
            this.symbolKeyModel.symbolAdded(s);
        }
    }

    void symbolRemoved(Symbol s) {
        if (this.isVisible()) {
            this.symbolKeyModel.symbolRemoved(s);
        }
    }

    void symbolChanged(Symbol s) {
        if (this.isVisible()) {
            this.symbolKeyModel.symbolChanged(s);
        }
    }

    void setProgram(Program program, SymbolInspector inspector) {
        this.renderer.setSymbolInspector(inspector);
        if (this.isVisible()) {
            this.symbolKeyModel.reload(program);
        }
    }

    GhidraTable getTable() {
        return this.symbolPanel.getTable();
    }

    SymbolFilter getFilter() {
        return this.symbolPanel.getFilter();
    }

    boolean isShowingDynamicSymbols() {
        return this.getFilter().acceptsDefaultLabelSymbols();
    }

    private String generateSubTitle() {
        int unfilteredCount;
        SymbolFilter filter = this.symbolKeyModel.getFilter();
        int rowCount = this.symbolKeyModel.getRowCount();
        if (rowCount != (unfilteredCount = this.symbolKeyModel.getUnfilteredRowCount())) {
            return " (Text filter matched " + rowCount + " of " + unfilteredCount + " symbols)";
        }
        if (filter.acceptsAll()) {
            return "(" + this.symbolPanel.getActualSymbolCount() + " Symbols)";
        }
        return "(Filter settings matched " + this.symbolPanel.getActualSymbolCount() + " Symbols)";
    }

    void open() {
        if (!this.isVisible()) {
            this.setVisible(true);
        }
    }

    boolean isBusy() {
        return this.symbolKeyModel.isBusy();
    }

    public void componentHidden() {
        this.symbolKeyModel.reload(null);
        if (this.plugin != null) {
            this.plugin.symbolProviderClosed();
        }
    }

    public void componentShown() {
        this.symbolKeyModel.reload(this.plugin.getProgram());
    }

    public JComponent getComponent() {
        return this.symbolPanel;
    }

    void readConfigState(SaveState saveState) {
        this.symbolPanel.readConfigState(saveState);
    }

    void writeConfigState(SaveState saveState) {
        this.symbolPanel.writeConfigState(saveState);
    }
}

