/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.searchtext;

import ghidra.app.plugin.core.searchtext.SearchOptions;
import ghidra.app.plugin.core.searchtext.Searcher;
import ghidra.app.util.query.ProgramLocationPreviewTableModel;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;

public abstract class AbstractSearchTableModel
extends ProgramLocationPreviewTableModel {
    static final String TITLE = "Text Search";
    protected SearchOptions options;
    protected int searchLimit;
    protected AddressSetView set;
    protected boolean showBlockName;
    private PluginTool tool;

    public AbstractSearchTableModel(PluginTool tool, Program p, AddressSetView set, SearchOptions options) {
        super(TITLE, (ServiceProvider)tool, p, null, true);
        this.tool = tool;
        this.set = set;
        this.options = options;
        ToolOptions opt = tool.getOptions("Search");
        this.searchLimit = opt.getInt("Search Limit", 500);
    }

    protected void doLoad(Accumulator<ProgramLocation> accumulator, TaskMonitor monitor) throws CancelledException {
        Searcher searcher = this.getSearcher(this.tool, monitor);
        monitor.checkCanceled();
        ProgramLocation loc = searcher.search();
        while (loc != null && accumulator.size() < this.searchLimit) {
            accumulator.add((Object)loc);
            monitor.checkCanceled();
            loc = searcher.search();
        }
    }

    protected abstract Searcher getSearcher(PluginTool var1, TaskMonitor var2);
}

