/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.register;

import docking.widgets.tree.GTreeNode;
import ghidra.app.plugin.core.register.RegisterTreeNode;
import ghidra.app.plugin.core.register.SearchableRegisterTreeNode;
import ghidra.program.model.lang.Register;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import resources.ResourceManager;

class RegisterTreeGroupNode
extends SearchableRegisterTreeNode {
    private static ImageIcon OPEN_ICON = ResourceManager.loadImage((String)"images/openSmallFolder.png");
    private static ImageIcon CLOSED_ICON = ResourceManager.loadImage((String)"images/closedSmallFolder.png");
    private String name;

    public RegisterTreeGroupNode(String name) {
        this.name = name;
    }

    public Icon getIcon(boolean expanded) {
        return expanded ? OPEN_ICON : CLOSED_ICON;
    }

    public String getName() {
        return this.name;
    }

    public String getToolTip() {
        return null;
    }

    public boolean isLeaf() {
        return false;
    }

    public void addRegister(Register register) {
        this.addNode(new RegisterTreeNode(register));
    }

    public int compareTo(GTreeNode o) {
        if (!(o instanceof RegisterTreeGroupNode)) {
            return -1;
        }
        return this.name.compareTo(o.getName());
    }
}

