/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functioncompare.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.action.ToolBarData;
import ghidra.app.plugin.core.functioncompare.FunctionComparisonPanel;
import ghidra.app.plugin.core.functioncompare.MultiFunctionComparisonPanel;
import ghidra.app.plugin.core.functioncompare.MultiFunctionComparisonProvider;
import ghidra.program.model.listing.Function;
import ghidra.util.HelpLocation;
import java.util.Arrays;
import java.util.HashSet;
import javax.swing.Icon;
import javax.swing.JComboBox;
import resources.MultiIcon;
import resources.ResourceManager;
import resources.icons.TranslateIcon;

public class RemoveFunctionsAction
extends DockingAction {
    private static final Icon FUNCTION_ICON = new TranslateIcon((Icon)ResourceManager.loadImage((String)"images/FunctionScope.gif"), -5, -2);
    private static final Icon REMOVE_ICON = new TranslateIcon((Icon)ResourceManager.loadImage((String)"images/edit-delete.png"), 3, 3);
    private static final String REMOVE_FUNCTION_GROUP = "A9_RemoveFunctions";
    private static final Icon REMOVE_FUNCTION_ICON = new MultiIcon(REMOVE_ICON, new Icon[]{FUNCTION_ICON});

    public RemoveFunctionsAction(MultiFunctionComparisonProvider provider) {
        super("Remove Functions", provider.getOwner());
        this.setKeyBindingData(new KeyBindingData('R', 192));
        this.setDescription("Removes function in the focused comparison panel");
        this.setPopupMenuData(new MenuData(new String[]{"Remove Function"}, REMOVE_FUNCTION_ICON, REMOVE_FUNCTION_GROUP));
        ToolBarData newToolBarData = new ToolBarData(REMOVE_FUNCTION_ICON, REMOVE_FUNCTION_GROUP);
        this.setToolBarData(newToolBarData);
        HelpLocation helpLocation = new HelpLocation("FunctionComparison", "Remove_From_Comparison");
        this.setHelpLocation(helpLocation);
    }

    public boolean isEnabledForContext(ActionContext context) {
        if (!(context.getComponentProvider() instanceof MultiFunctionComparisonProvider)) {
            return false;
        }
        MultiFunctionComparisonProvider provider = (MultiFunctionComparisonProvider)context.getComponentProvider();
        FunctionComparisonPanel comp = provider.getComponent();
        if (!(comp instanceof MultiFunctionComparisonPanel)) {
            return false;
        }
        MultiFunctionComparisonPanel panel = (MultiFunctionComparisonPanel)comp;
        JComboBox<Function> focusedComponent = panel.getFocusedComponent();
        return focusedComponent.getSelectedIndex() != -1;
    }

    public void actionPerformed(ActionContext context) {
        MultiFunctionComparisonProvider provider = (MultiFunctionComparisonProvider)context.getComponentProvider();
        JComboBox<Function> focusedComponent = ((MultiFunctionComparisonPanel)provider.getComponent()).getFocusedComponent();
        Function selectedFunction = (Function)focusedComponent.getSelectedItem();
        provider.removeFunctions(new HashSet<Function>(Arrays.asList(selectedFunction)));
        provider.contextChanged();
    }
}

