/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.archive;

import ghidra.app.plugin.core.datamgr.archive.Archive;
import ghidra.app.plugin.core.datamgr.archive.DataTypeManagerHandler;
import ghidra.program.model.data.ArchiveType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.SourceArchive;
import ghidra.util.UniversalID;
import ghidra.util.exception.DuplicateFileException;
import java.awt.Component;
import java.io.IOException;
import javax.swing.ImageIcon;
import resources.ResourceManager;

public class InvalidFileArchive
implements Archive {
    private static final ImageIcon INVALID_ARCHIVE_ICON = ResourceManager.loadImage((String)"images/closedFolderInvalid.png");
    private DataTypeManagerHandler archiveManager;
    private UniversalID universalID;
    private ArchiveType archiveType;
    private String name;
    private String domainFileID;

    InvalidFileArchive(DataTypeManagerHandler archiveManager, SourceArchive sourceArchive) {
        this.archiveManager = archiveManager;
        this.universalID = sourceArchive.getSourceArchiveID();
        this.archiveType = sourceArchive.getArchiveType();
        this.name = sourceArchive.getName();
        this.domainFileID = sourceArchive.getDomainFileID();
    }

    public DataTypeManager getDataTypeManager() {
        return null;
    }

    @Override
    public boolean isModifiable() {
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int compareTo(Archive archive) {
        if (archive instanceof InvalidFileArchive) {
            return this.getName().compareToIgnoreCase(archive.getName());
        }
        return 1;
    }

    public ArchiveType getArchiveType() {
        return this.archiveType;
    }

    public String getDomainFileID() {
        return this.domainFileID;
    }

    @Override
    public void close() {
        this.archiveManager.archiveClosed(this);
    }

    @Override
    public boolean isChanged() {
        return false;
    }

    @Override
    public boolean isSavable() {
        return false;
    }

    @Override
    public void save() throws DuplicateFileException, IOException {
    }

    @Override
    public void saveAs(Component component) throws IOException {
    }

    public UniversalID getUniversalID() {
        return this.universalID;
    }

    @Override
    public ImageIcon getIcon(boolean expanded) {
        return INVALID_ARCHIVE_ICON;
    }
}

