/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.codebrowser;

import docking.Tool;
import docking.action.builder.AbstractActionBuilder;
import docking.action.builder.ActionBuilder;
import ghidra.app.plugin.core.codebrowser.CodeViewerActionContext;
import ghidra.app.plugin.core.codebrowser.CodeViewerProvider;
import ghidra.app.plugin.core.table.TableComponentProvider;
import ghidra.app.util.PluginConstants;
import ghidra.app.util.query.TableService;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.CodeUnitIterator;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramSelection;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.table.CustomLoadingAddressTableModel;
import ghidra.util.table.GhidraProgramTableModel;
import ghidra.util.table.TableModelLoader;
import ghidra.util.task.TaskMonitor;
import javax.swing.ImageIcon;
import resources.ResourceManager;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Common", shortDescription="Basic Selection actions", description="This plugin provides actions for Code Browser Listing components")
public class CodeBrowserSelectionPlugin
extends Plugin {
    private static final String SELECTION_LIMIT_OPTION_NAME = "Table From Selection Limit";

    public CodeBrowserSelectionPlugin(PluginTool tool) {
        super(tool);
        this.createActions();
    }

    private void createActions() {
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Select All", this.getName()).menuPath(new String[]{"Se&lect", "&All in View"})).menuGroup("Select Group", "a")).keyBinding("ctrl A")).supportsDefaultToolContext(true)).helpLocation(new HelpLocation("Selection", "Select All"))).withContext(CodeViewerActionContext.class).inWindow(AbstractActionBuilder.When.CONTEXT_MATCHES).onAction(c -> ((CodeViewerProvider)c.getComponentProvider()).selectAll()).buildAndInstall((Tool)this.tool);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Clear Selection", this.getName()).menuPath(new String[]{"Se&lect", "&Clear Selection"})).menuGroup("Select Group", "b")).supportsDefaultToolContext(true)).helpLocation(new HelpLocation("Selection", "Clear Selection"))).withContext(CodeViewerActionContext.class).inWindow(AbstractActionBuilder.When.CONTEXT_MATCHES).onAction(c -> ((CodeViewerProvider)c.getComponentProvider()).setSelection(new ProgramSelection())).buildAndInstall((Tool)this.tool);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Select Complement", this.getName()).menuPath(new String[]{"Se&lect", "&Complement"})).menuGroup("Select Group", "c")).supportsDefaultToolContext(true)).helpLocation(new HelpLocation("Selection", "Select Complement"))).withContext(CodeViewerActionContext.class).inWindow(AbstractActionBuilder.When.CONTEXT_MATCHES).onAction(c -> ((CodeViewerProvider)c.getComponentProvider()).selectComplement()).buildAndInstall((Tool)this.tool);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Create Table From Selection", this.getName()).menuPath(new String[]{"Se&lect", "Create Table From Selection"})).menuGroup("SelectUtils")).helpLocation(new HelpLocation("CodeBrowserPlugin", "Selection_Table"))).supportsDefaultToolContext(true)).withContext(CodeViewerActionContext.class).inWindow(AbstractActionBuilder.When.CONTEXT_MATCHES).onAction(c -> this.createTable((CodeViewerProvider)c.getComponentProvider())).buildAndInstall((Tool)this.tool);
    }

    private void createTable(CodeViewerProvider componentProvider) {
        ProgramSelection selection;
        TableService tableService = (TableService)this.tool.getService(TableService.class);
        if (tableService == null) {
            Msg.showWarn((Object)((Object)this), null, (String)"No Table Service", (Object)"Please add the TableServicePlugin.");
            return;
        }
        Program program = componentProvider.getProgram();
        Listing listing = program.getListing();
        CodeUnitIterator codeUnits = listing.getCodeUnits((AddressSetView)(selection = componentProvider.getSelection()), true);
        if (!codeUnits.hasNext()) {
            this.tool.setStatusInfo("Unable to create table from selection: no code units in selection");
            return;
        }
        GhidraProgramTableModel<Address> model = this.createTableModel(program, codeUnits, selection);
        String title = "Selection Table";
        ImageIcon markerIcon = ResourceManager.loadImage((String)"images/searchm_obj.gif");
        TableComponentProvider<Address> tableProvider = tableService.showTableWithMarkers(title + " " + model.getName(), "Selection", model, PluginConstants.SEARCH_HIGHLIGHT_COLOR, markerIcon, title, null);
        tableProvider.installRemoveItemsAction();
    }

    private GhidraProgramTableModel<Address> createTableModel(Program program, CodeUnitIterator iterator, ProgramSelection selection) {
        CodeUnitFromSelectionTableModelLoader loader = new CodeUnitFromSelectionTableModelLoader(iterator, selection);
        return new CustomLoadingAddressTableModel(" - from " + selection.getMinAddress(), (ServiceProvider)this.tool, program, loader, null, true);
    }

    private class CodeUnitFromSelectionTableModelLoader
    implements TableModelLoader<Address> {
        private CodeUnitIterator iterator;
        private ProgramSelection selection;

        CodeUnitFromSelectionTableModelLoader(CodeUnitIterator iterator, ProgramSelection selection) {
            this.iterator = iterator;
            this.selection = selection;
        }

        @Override
        public void load(Accumulator<Address> accumulator, TaskMonitor monitor) throws CancelledException {
            ToolOptions options = CodeBrowserSelectionPlugin.this.tool.getOptions("Tool");
            int resultsLimit = options.getInt("Search Limit", 500);
            long size = this.selection.getNumAddresses();
            monitor.initialize(size);
            while (this.iterator.hasNext()) {
                if (accumulator.size() >= resultsLimit) {
                    Msg.showWarn((Object)this, null, (String)"Results Truncated", (Object)("Results are limited to " + resultsLimit + " code units.\nThis limit can be changed by the tool option \"Tool -> Table From Selection Limit\"."));
                    break;
                }
                monitor.checkCanceled();
                CodeUnit cu = this.iterator.next();
                accumulator.add((Object)cu.getMinAddress());
                monitor.incrementProgress((long)cu.getLength());
            }
        }
    }
}

