/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.merge.propertylist;

import ghidra.app.merge.ProgramMultiUserMergeManager;
import ghidra.app.merge.propertylist.ConflictInfo;
import ghidra.app.merge.propertylist.ConflictPanel;
import ghidra.app.merge.util.ConflictCountPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class PropertyListMergePanel
extends JPanel {
    public static final String LATEST_BUTTON_NAME = "Latest";
    public static final String CHECKED_OUT_BUTTON_NAME = "Checked Out";
    public static final String ORIGINAL_BUTTON_NAME = "Original";
    private int totalConflicts;
    private ConflictPanel conflictPanel;
    private ConflictCountPanel countPanel;
    private ProgramMultiUserMergeManager mergeManager;

    PropertyListMergePanel(ProgramMultiUserMergeManager mergeManager, int totalConflicts) {
        this.mergeManager = mergeManager;
        this.totalConflicts = totalConflicts;
        this.create();
    }

    void setConflictInfo(int conflictIndex, ConflictInfo info) {
        this.mergeManager.clearStatusText();
        this.conflictPanel.setConflictInfo(info);
        this.countPanel.updateCount(conflictIndex, this.totalConflicts);
    }

    int getSelectedOption() {
        return this.conflictPanel.getSelectedOption();
    }

    private void create() {
        this.countPanel = new ConflictCountPanel();
        this.conflictPanel = this.createConflictPanel();
        this.setLayout(new BorderLayout(0, 20));
        this.setBorder(BorderFactory.createEmptyBorder(10, 5, 0, 5));
        this.add((Component)this.countPanel, "North");
        this.add((Component)this.conflictPanel, "Center");
    }

    private ConflictPanel createConflictPanel() {
        ChangeListener changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PropertyListMergePanel.this.mergeManager.clearStatusText();
                PropertyListMergePanel.this.mergeManager.setApplyEnabled(true);
            }
        };
        this.conflictPanel = new ConflictPanel(changeListener);
        Dimension d = this.conflictPanel.getPreferredSize();
        this.conflictPanel.setPreferredSize(new Dimension(400, d.height));
        return this.conflictPanel;
    }

    void setUseForAll(boolean useForAll) {
        this.conflictPanel.setUseForAll(useForAll);
    }

    boolean getUseForAll() {
        return this.conflictPanel.getUseForAll();
    }
}

