/*
 * Decompiled with CFR 0.152.
 */
package ghidra.async;

import ghidra.async.AsyncUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiPredicate;
import java.util.function.Function;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class AsyncLazyMap<K, V> {
    protected final Map<K, KeyedFuture<K, V>> futures = new HashMap<K, KeyedFuture<K, V>>();
    protected final Map<K, V> map;
    protected final Map<K, V> unmodifiable;
    protected final Function<K, CompletableFuture<V>> function;
    protected BiPredicate<? super K, ? super Throwable> forgetErrors = (k, t) -> true;
    protected BiPredicate<? super K, ? super V> forgetValues = (k, v) -> false;

    public AsyncLazyMap(Map<K, V> map, Function<K, CompletableFuture<V>> function) {
        this.map = map;
        this.unmodifiable = Collections.unmodifiableMap(map);
        this.function = function;
    }

    protected void putFuture(K key, KeyedFuture<K, V> future) {
        this.futures.put(key, future);
        ((CompletableFuture)future.exceptionally(exc -> {
            AsyncLazyMap asyncLazyMap = this;
            synchronized (asyncLazyMap) {
                if (this.forgetErrors.test(key, (Throwable)exc)) {
                    this.futures.remove(key);
                }
            }
            return ExceptionUtils.rethrow((Throwable)exc);
        })).thenAccept(val -> {
            AsyncLazyMap asyncLazyMap = this;
            synchronized (asyncLazyMap) {
                if (this.futures.get(key) != future) {
                    return;
                }
                if (this.forgetValues.test(key, val)) {
                    this.futures.remove(key);
                    return;
                }
                this.map.put(key, val);
            }
        });
    }

    public synchronized AsyncLazyMap<K, V> forgetErrors(BiPredicate<? super K, ? super Throwable> predicate) {
        this.forgetErrors = predicate;
        return this;
    }

    public AsyncLazyMap<K, V> rememberErrors(BiPredicate<? super K, ? super Throwable> predicate) {
        return this.forgetErrors((k, t) -> !predicate.test((Object)k, (Throwable)t));
    }

    public synchronized AsyncLazyMap<K, V> forgetValues(BiPredicate<? super K, ? super V> predicate) {
        this.forgetValues = predicate;
        return this;
    }

    public synchronized AsyncLazyMap<K, V> rememberValues(BiPredicate<? super K, ? super V> predicate) {
        return this.forgetValues((k, v) -> !predicate.test((Object)k, (Object)v));
    }

    public synchronized KeyedFuture<K, V> get(K key, Function<K, CompletableFuture<V>> func) {
        KeyedFuture<K, V> future = this.futures.get(key);
        if (!(future == null || future.isDone() && this.forgetValues.test(key, future.getNow(null)))) {
            return future;
        }
        KeyedFuture f = new KeyedFuture(key);
        this.putFuture(key, f);
        CompletableFuture<V> dep = func.apply(key);
        f.future = dep;
        dep.handle(AsyncUtils.copyTo(f));
        return f;
    }

    public synchronized KeyedFuture<K, V> get(K key) {
        return this.get(key, this.function);
    }

    public synchronized boolean put(K key, V value) {
        KeyedFuture<K, V> future = this.futures.get(key);
        if (future != null) {
            return future.complete(value);
        }
        future = new KeyedFuture<K, V>(key, value);
        this.futures.put(key, future);
        this.map.put(key, value);
        return true;
    }

    public synchronized KeyedFuture<K, V> put(K key) {
        KeyedFuture<K, V> future = this.futures.get(key);
        if (future != null) {
            return future;
        }
        future = new KeyedFuture(key);
        this.putFuture(key, future);
        return future;
    }

    public synchronized CompletableFuture<V> forget(K key) {
        this.map.remove(key);
        return this.futures.remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V remove(K key) {
        V val;
        KeyedFuture<K, V> f;
        AsyncLazyMap asyncLazyMap = this;
        synchronized (asyncLazyMap) {
            f = this.futures.remove(key);
            val = this.map.remove(key);
        }
        if (f != null) {
            f.cancel(false);
        }
        return val;
    }

    public Map<K, V> getCompletedMap() {
        return this.unmodifiable;
    }

    public synchronized Set<K> getPendingKeySet() {
        LinkedHashSet result = new LinkedHashSet();
        for (KeyedFuture<K, V> f : this.futures.values()) {
            if (f.isDone()) continue;
            result.add(f.key);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        LinkedHashSet<KeyedFuture<K, V>> copy = new LinkedHashSet<KeyedFuture<K, V>>();
        AsyncLazyMap asyncLazyMap = this;
        synchronized (asyncLazyMap) {
            copy.addAll(this.futures.values());
            this.futures.clear();
            this.map.clear();
        }
        for (KeyedFuture keyedFuture : copy) {
            keyedFuture.cancel(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retainKeys(Collection<K> keys) {
        LinkedHashSet<KeyedFuture<K, V>> removed = new LinkedHashSet<KeyedFuture<K, V>>();
        AsyncLazyMap asyncLazyMap = this;
        synchronized (asyncLazyMap) {
            Iterator<Map.Entry<K, KeyedFuture<K, V>>> iterator = this.futures.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<K, KeyedFuture<K, V>> ent = iterator.next();
                if (keys.contains(ent.getKey())) continue;
                removed.add(ent.getValue());
                iterator.remove();
            }
            this.map.keySet().retainAll(keys);
        }
        for (KeyedFuture keyedFuture : removed) {
            keyedFuture.cancel(false);
        }
    }

    public synchronized boolean containsKey(K key) {
        return this.futures.containsKey(key) || this.map.containsKey(key);
    }

    public static class KeyedFuture<K, V>
    extends CompletableFuture<V> {
        protected final K key;
        protected CompletableFuture<V> future;

        public KeyedFuture(K key) {
            this.key = key;
        }

        public KeyedFuture(K key, V value) {
            this(key);
            this.complete(value);
        }

        @Override
        public String toString() {
            return this.key + "=" + super.toString();
        }

        public K getKey() {
            return this.key;
        }

        public CompletableFuture<V> getFuture() {
            return this.future;
        }
    }
}

