/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.exec;

import ghidra.pcode.exec.PcodeExecutionException;
import ghidra.pcode.exec.PcodeExecutorStatePiece;
import ghidra.pcode.exec.SleighUseropLibrary;
import ghidra.program.model.pcode.Varnode;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.reflect.TypeUtils;

public abstract class AnnotatedSleighUseropLibrary<T>
implements SleighUseropLibrary<T> {
    private static final Map<Class<?>, Set<Method>> CACHE_BY_CLASS = new HashMap();
    Map<String, SleighUseropLibrary.SleighUseropDefinition<T>> ops = new HashMap<String, SleighUseropLibrary.SleighUseropDefinition<T>>();

    private static Set<Method> collectDefinitions(Class<? extends AnnotatedSleighUseropLibrary<?>> cls) {
        HashSet<Method> defs = new HashSet<Method>();
        AnnotatedSleighUseropLibrary.collectDefinitions(cls, defs, new HashSet());
        return defs;
    }

    private static void collectDefinitions(Class<?> cls, Set<Method> defs, Set<Class<?>> visited) {
        if (!visited.add(cls)) {
            return;
        }
        Class<?> superCls = cls.getSuperclass();
        if (superCls != null) {
            AnnotatedSleighUseropLibrary.collectDefinitions(superCls, defs, visited);
        }
        for (Class<?> superIf : cls.getInterfaces()) {
            AnnotatedSleighUseropLibrary.collectDefinitions(superIf, defs, visited);
        }
        AnnotatedSleighUseropLibrary.collectClassDefinitions(cls, defs);
    }

    private static void collectClassDefinitions(Class<?> cls, Set<Method> defs) {
        for (Method method : cls.getDeclaredMethods()) {
            SleighUserop annot = method.getAnnotation(SleighUserop.class);
            if (annot == null) continue;
            defs.add(method);
        }
    }

    public AnnotatedSleighUseropLibrary() {
        MethodHandles.Lookup lookup = this.getMethodLookup();
        Class<T> opType = this.getOperandType();
        Class<?> cls = this.getClass();
        Set methods = CACHE_BY_CLASS.computeIfAbsent(cls, __ -> AnnotatedSleighUseropLibrary.collectDefinitions(cls));
        for (Method m : methods) {
            this.ops.put(m.getName(), new AnnotatedSleighUseropDefinition<T>(this, opType, lookup, m));
        }
    }

    protected Class<T> getOperandType() {
        Map args = TypeUtils.getTypeArguments(this.getClass(), AnnotatedSleighUseropLibrary.class);
        if (args == null) {
            return Object.class;
        }
        Type type = (Type)args.get(AnnotatedSleighUseropLibrary.class.getTypeParameters()[0]);
        if (!(type instanceof Class)) {
            return Object.class;
        }
        return (Class)type;
    }

    protected MethodHandles.Lookup getMethodLookup() {
        return MethodHandles.lookup();
    }

    @Override
    public Map<String, SleighUseropLibrary.SleighUseropDefinition<T>> getUserops() {
        return this.ops;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface SleighUserop {
    }

    static class AnnotatedSleighUseropDefinition<T>
    implements SleighUseropLibrary.SleighUseropDefinition<T> {
        private final Method method;
        private final MethodHandle handle;

        public AnnotatedSleighUseropDefinition(AnnotatedSleighUseropLibrary<T> library, Class<T> opType, MethodHandles.Lookup lookup, Method method) {
            this.method = method;
            try {
                this.handle = lookup.unreflect(method).bindTo(library);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)("Cannot access " + method + " having @" + SleighUserop.class.getSimpleName() + " annotation. Override getMethodLookup()"));
            }
            for (Class<?> ptype : method.getParameterTypes()) {
                if (Varnode.class.isAssignableFrom(ptype) || opType.isAssignableFrom(ptype)) continue;
                throw new IllegalArgumentException("pcode userops can only take Varnode inputs");
            }
        }

        @Override
        public String getName() {
            return this.method.getName();
        }

        @Override
        public int getOperandCount() {
            return this.method.getParameterCount();
        }

        @Override
        public void execute(PcodeExecutorStatePiece<T, T> state, Varnode outVar, List<Varnode> inVars) {
            List<Object> args = Arrays.asList(new Object[inVars.size()]);
            Class<?>[] ptypes = this.method.getParameterTypes();
            for (int i = 0; i < args.size(); ++i) {
                if (Varnode.class.isAssignableFrom(ptypes[i])) {
                    args.set(i, inVars.get(i));
                    continue;
                }
                args.set(i, state.getVar(inVars.get(i)));
            }
            try {
                this.handle.invokeWithArguments(args);
            }
            catch (PcodeExecutionException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new PcodeExecutionException("Error executing userop", null, e);
            }
        }
    }
}

