/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgmodel.impl.dbgmodel.main;

import agent.dbgmodel.dbgmodel.COMUtilsExtra;
import agent.dbgmodel.dbgmodel.DbgModel;
import agent.dbgmodel.dbgmodel.main.ModelObject;
import agent.dbgmodel.impl.dbgmodel.main.KeyEnumeratorInternal;
import agent.dbgmodel.impl.dbgmodel.main.ModelObjectImpl;
import agent.dbgmodel.jna.dbgmodel.main.IKeyEnumerator;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.COM.COMUtils;
import com.sun.jna.platform.win32.OleAuto;
import com.sun.jna.platform.win32.WTypes;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.PointerByReference;

public class KeyEnumeratorImpl
implements KeyEnumeratorInternal {
    private final DbgModel.OpaqueCleanable cleanable;
    private final IKeyEnumerator jnaData;
    private ModelObject value;

    public KeyEnumeratorImpl(IKeyEnumerator jnaData) {
        this.cleanable = DbgModel.releaseWhenPhantom((Object)this, jnaData);
        this.jnaData = jnaData;
    }

    @Override
    public Pointer getPointer() {
        return this.jnaData.getPointer();
    }

    @Override
    public void reset() {
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.Reset());
    }

    @Override
    public String getNext() {
        WTypes.BSTRByReference bref = new WTypes.BSTRByReference();
        PointerByReference ppValue = new PointerByReference();
        PointerByReference ppMetaData = new PointerByReference();
        WinNT.HRESULT hr = this.jnaData.GetNext(bref, ppValue, ppMetaData);
        if (hr.equals((Object)COMUtilsExtra.E_BOUNDS) || hr.equals((Object)COMUtilsExtra.E_FAIL)) {
            return null;
        }
        COMUtils.checkRC((WinNT.HRESULT)hr);
        Pointer val = ppValue.getValue();
        this.value = val != null ? ModelObjectImpl.getObjectWithMetadata(ppValue, ppMetaData) : null;
        WTypes.BSTR bstr = bref.getValue();
        String key = bstr.getValue();
        OleAuto.INSTANCE.SysFreeString(bstr);
        return key;
    }

    @Override
    public ModelObject getValue() {
        return this.value;
    }
}

