/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgmodel.impl.dbgmodel.debughost;

import agent.dbgmodel.dbgmodel.COMUtilsExtra;
import agent.dbgmodel.dbgmodel.debughost.DebugHostSymbol1;
import agent.dbgmodel.dbgmodel.debughost.DebugHostType1;
import agent.dbgmodel.impl.dbgmodel.debughost.DebugHostBaseClassImpl;
import agent.dbgmodel.impl.dbgmodel.debughost.DebugHostSymbolInternal;
import agent.dbgmodel.impl.dbgmodel.debughost.DebugHostTypeInternal;
import agent.dbgmodel.jna.dbgmodel.DbgModelNative;
import agent.dbgmodel.jna.dbgmodel.debughost.IDebugHostType1;
import agent.dbgmodel.jna.dbgmodel.debughost.WrapIDebugHostSymbol1;
import agent.dbgmodel.jna.dbgmodel.debughost.WrapIDebugHostType1;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.COM.COMUtils;
import com.sun.jna.platform.win32.WTypes;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.PointerByReference;

public class DebugHostTypeImpl1
extends DebugHostBaseClassImpl
implements DebugHostTypeInternal {
    private final IDebugHostType1 jnaData;
    private WinDef.ULONG intrinsicKind;
    private WTypes.VARTYPE carrierType;
    private WinDef.ULONG lsbOfField;
    private WinDef.ULONG lengthOfField;

    public DebugHostTypeImpl1(IDebugHostType1 jnaData) {
        super(jnaData);
        this.jnaData = jnaData;
    }

    @Override
    public Pointer getPointer() {
        return this.jnaData.getPointer();
    }

    @Override
    public DbgModelNative.TypeKind getTypeKind() {
        WinDef.ULONGByReference pulKind = new WinDef.ULONGByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.GetTypeKind(pulKind));
        return DbgModelNative.TypeKind.values()[pulKind.getValue().intValue()];
    }

    @Override
    public long getSize() {
        WinDef.ULONGLONGByReference pulSize = new WinDef.ULONGLONGByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.GetSize(pulSize));
        return pulSize.getValue().longValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DebugHostType1 getBaseType() {
        PointerByReference ppBaseType = new PointerByReference();
        WinNT.HRESULT hr = this.jnaData.GetBaseType(ppBaseType);
        if (hr.equals((Object)COMUtilsExtra.E_FAIL)) {
            return null;
        }
        COMUtils.checkRC((WinNT.HRESULT)hr);
        WrapIDebugHostType1 wrap = new WrapIDebugHostType1(ppBaseType.getValue());
        try {
            DebugHostTypeInternal debugHostTypeInternal = DebugHostTypeInternal.tryPreferredInterfaces(wrap::QueryInterface);
            return debugHostTypeInternal;
        }
        finally {
            wrap.Release();
        }
    }

    @Override
    public int getHashCode() {
        WinDef.ULONGByReference pulHashCode = new WinDef.ULONGByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.GetHashCode(pulHashCode));
        return pulHashCode.getValue().intValue();
    }

    @Override
    public DbgModelNative.IntrinsicKind getIntrinsicType() {
        WinDef.ULONGByReference pulIntrinsicKind = new WinDef.ULONGByReference();
        WTypes.VARTYPEByReference pCarrierType = new WTypes.VARTYPEByReference();
        WinNT.HRESULT hr = this.jnaData.GetIntrinsicType(pulIntrinsicKind, pCarrierType);
        if (hr.equals((Object)COMUtilsExtra.E_FAIL)) {
            return null;
        }
        COMUtils.checkRC((WinNT.HRESULT)hr);
        this.carrierType = pCarrierType.getValue();
        int intValue = pulIntrinsicKind.getValue().intValue();
        return DbgModelNative.IntrinsicKind.values()[intValue];
    }

    @Override
    public void getBitField() {
        WinDef.ULONGByReference pulLsbOfField = new WinDef.ULONGByReference();
        WinDef.ULONGByReference pulLengthOfField = new WinDef.ULONGByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.GetBitField(pulLsbOfField, pulLengthOfField));
        this.lsbOfField = pulLsbOfField.getValue();
        this.lengthOfField = pulLengthOfField.getValue();
    }

    @Override
    public DbgModelNative.PointerKind getPointerKind() {
        WinDef.ULONGByReference pulPointerKind = new WinDef.ULONGByReference();
        WinNT.HRESULT hr = this.jnaData.GetPointerKind(pulPointerKind);
        if (hr.equals((Object)COMUtilsExtra.E_FAIL)) {
            return null;
        }
        COMUtils.checkRC((WinNT.HRESULT)hr);
        return DbgModelNative.PointerKind.values()[pulPointerKind.getValue().intValue()];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DebugHostType1 getMemberType() {
        PointerByReference ppMemberType = new PointerByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.GetMemberType(ppMemberType));
        WrapIDebugHostType1 wrap = new WrapIDebugHostType1(ppMemberType.getValue());
        try {
            DebugHostTypeInternal debugHostTypeInternal = DebugHostTypeInternal.tryPreferredInterfaces(wrap::QueryInterface);
            return debugHostTypeInternal;
        }
        finally {
            wrap.Release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DebugHostType1 createPointerTo(int kind) {
        WinDef.ULONG ulKind = new WinDef.ULONG((long)kind);
        PointerByReference ppMemberType = new PointerByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.CreatePointerTo(ulKind, ppMemberType));
        WrapIDebugHostType1 wrap = new WrapIDebugHostType1(ppMemberType.getValue());
        try {
            DebugHostTypeInternal debugHostTypeInternal = DebugHostTypeInternal.tryPreferredInterfaces(wrap::QueryInterface);
            return debugHostTypeInternal;
        }
        finally {
            wrap.Release();
        }
    }

    @Override
    public long getArrayDimensionality() {
        WinDef.ULONGLONGByReference pulArrayDimensionality = new WinDef.ULONGLONGByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.GetArrayDimensionality(pulArrayDimensionality));
        return pulArrayDimensionality.getValue().longValue();
    }

    @Override
    public DbgModelNative.ARRAY_DIMENSION getArrayDimensions(long dimensions) {
        WinDef.ULONGLONG pDimensions = new WinDef.ULONGLONG(dimensions);
        DbgModelNative.ARRAY_DIMENSION.ByReference ppDimensions = new DbgModelNative.ARRAY_DIMENSION.ByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.GetArrayDimensions(pDimensions, ppDimensions));
        return new DbgModelNative.ARRAY_DIMENSION(ppDimensions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DebugHostType1 createArrayOf(long dimensions, DbgModelNative.ARRAY_DIMENSION.ByReference pDimensions) {
        WinDef.ULONGLONG ulDimensions = new WinDef.ULONGLONG(dimensions);
        PointerByReference ppNewType = new PointerByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.CreateArrayOf(ulDimensions, pDimensions, ppNewType));
        WrapIDebugHostType1 wrap = new WrapIDebugHostType1(ppNewType.getValue());
        try {
            DebugHostTypeInternal debugHostTypeInternal = DebugHostTypeInternal.tryPreferredInterfaces(wrap::QueryInterface);
            return debugHostTypeInternal;
        }
        finally {
            wrap.Release();
        }
    }

    @Override
    public int getFunctionCallingConvention() {
        WinDef.ULONGByReference pulConventionKind = new WinDef.ULONGByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.GetFunctionCallingConvention(pulConventionKind));
        return pulConventionKind.getValue().intValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DebugHostType1 getFunctionReturnType() {
        PointerByReference ppReturnType = new PointerByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.GetFunctionReturnType(ppReturnType));
        WrapIDebugHostType1 wrap = new WrapIDebugHostType1(ppReturnType.getValue());
        try {
            DebugHostTypeInternal debugHostTypeInternal = DebugHostTypeInternal.tryPreferredInterfaces(wrap::QueryInterface);
            return debugHostTypeInternal;
        }
        finally {
            wrap.Release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DebugHostType1 getFunctionParameterTypeAt(int i) {
        WinDef.ULONG ulI = new WinDef.ULONG((long)i);
        PointerByReference ppReturnType = new PointerByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.GetFunctionParameterTypeAt(ulI, ppReturnType));
        WrapIDebugHostType1 wrap = new WrapIDebugHostType1(ppReturnType.getValue());
        try {
            DebugHostTypeInternal debugHostTypeInternal = DebugHostTypeInternal.tryPreferredInterfaces(wrap::QueryInterface);
            return debugHostTypeInternal;
        }
        finally {
            wrap.Release();
        }
    }

    @Override
    public boolean isGeneric() {
        WinDef.BOOLByReference bIsGeneric = new WinDef.BOOLByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.IsGeneric(bIsGeneric));
        return bIsGeneric.getValue().booleanValue();
    }

    @Override
    public long getGenericArgumentCount() {
        WinDef.ULONGLONGByReference pulArgCount = new WinDef.ULONGLONGByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.GetGenericArgumentCount(pulArgCount));
        return pulArgCount.getValue().longValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DebugHostSymbol1 getGenericArgumentAt(int i) {
        WinDef.ULONG ulI = new WinDef.ULONG((long)i);
        PointerByReference ppArgument = new PointerByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.GetGenericArgumentAt(ulI, ppArgument));
        WrapIDebugHostSymbol1 wrap = new WrapIDebugHostSymbol1(ppArgument.getValue());
        try {
            DebugHostSymbolInternal debugHostSymbolInternal = DebugHostSymbolInternal.tryPreferredInterfaces(wrap::QueryInterface);
            return debugHostSymbolInternal;
        }
        finally {
            wrap.Release();
        }
    }

    public WinDef.ULONG getIntrinsicKind() {
        return this.intrinsicKind;
    }

    public WTypes.VARTYPE getCarrierType() {
        return this.carrierType;
    }

    public WinDef.ULONG getLsbOfField() {
        return this.lsbOfField;
    }

    public WinDef.ULONG getLengthOfField() {
        return this.lengthOfField;
    }
}

