/*
 * Decompiled with CFR 0.152.
 */
package mdemangler;

import java.math.BigInteger;
import mdemangler.MDEncodedNumber;
import mdemangler.MDException;
import mdemangler.MDMang;

public class MDSignedEncodedNumber
extends MDEncodedNumber {
    boolean signed = false;

    public MDSignedEncodedNumber(MDMang dmang) {
        super(dmang);
    }

    @Override
    public BigInteger getValue() {
        if (this.signed) {
            return this.value.negate();
        }
        return this.value;
    }

    @Override
    public void setValue(BigInteger value) {
        if (value.signum() == -1) {
            this.value = value.negate();
            this.signed = true;
        } else {
            this.value = value;
            this.signed = false;
        }
    }

    @Override
    public void insert(StringBuilder builder) {
        super.insert(builder);
        if (this.signed) {
            this.dmang.insertString(builder, "-");
        }
    }

    @Override
    protected void parseInternal() throws MDException {
        if (this.dmang.peek() == '?') {
            this.signed = true;
            this.dmang.increment();
        }
        super.parseInternal();
    }
}

