/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.EncodedValue;

import org.jf.dexlib.DexFile;
import org.jf.dexlib.EncodedValue.AnnotationEncodedValue;
import org.jf.dexlib.EncodedValue.ArrayEncodedValue;
import org.jf.dexlib.EncodedValue.BooleanEncodedValue;
import org.jf.dexlib.EncodedValue.ByteEncodedValue;
import org.jf.dexlib.EncodedValue.CharEncodedValue;
import org.jf.dexlib.EncodedValue.DoubleEncodedValue;
import org.jf.dexlib.EncodedValue.EnumEncodedValue;
import org.jf.dexlib.EncodedValue.FieldEncodedValue;
import org.jf.dexlib.EncodedValue.FloatEncodedValue;
import org.jf.dexlib.EncodedValue.IntEncodedValue;
import org.jf.dexlib.EncodedValue.LongEncodedValue;
import org.jf.dexlib.EncodedValue.MethodEncodedValue;
import org.jf.dexlib.EncodedValue.NullEncodedValue;
import org.jf.dexlib.EncodedValue.ShortEncodedValue;
import org.jf.dexlib.EncodedValue.StringEncodedValue;
import org.jf.dexlib.EncodedValue.TypeEncodedValue;
import org.jf.dexlib.EncodedValue.ValueType;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.Input;

public abstract class EncodedValue
implements Comparable<EncodedValue> {
    public abstract void writeValue(AnnotatedOutput var1);

    public abstract int placeValue(int var1);

    public static EncodedValue readEncodedValue(DexFile dexFile, Input in) {
        Byte b = in.readByte();
        ValueType valueType = ValueType.fromByte((byte)(b & 0x1F));
        byte valueArg = (byte)((b & 0xFF) >> 5);
        switch (valueType) {
            case VALUE_BYTE: {
                return new ByteEncodedValue(in);
            }
            case VALUE_SHORT: {
                return new ShortEncodedValue(in, valueArg);
            }
            case VALUE_CHAR: {
                return new CharEncodedValue(in, valueArg);
            }
            case VALUE_INT: {
                return new IntEncodedValue(in, valueArg);
            }
            case VALUE_LONG: {
                return new LongEncodedValue(in, valueArg);
            }
            case VALUE_FLOAT: {
                return new FloatEncodedValue(in, valueArg);
            }
            case VALUE_DOUBLE: {
                return new DoubleEncodedValue(in, valueArg);
            }
            case VALUE_STRING: {
                return new StringEncodedValue(dexFile, in, valueArg);
            }
            case VALUE_TYPE: {
                return new TypeEncodedValue(dexFile, in, valueArg);
            }
            case VALUE_FIELD: {
                return new FieldEncodedValue(dexFile, in, valueArg);
            }
            case VALUE_METHOD: {
                return new MethodEncodedValue(dexFile, in, valueArg);
            }
            case VALUE_ENUM: {
                return new EnumEncodedValue(dexFile, in, valueArg);
            }
            case VALUE_ARRAY: {
                return new ArrayEncodedValue(dexFile, in);
            }
            case VALUE_ANNOTATION: {
                return new AnnotationEncodedValue(dexFile, in);
            }
            case VALUE_NULL: {
                return NullEncodedValue.NullValue;
            }
            case VALUE_BOOLEAN: {
                return BooleanEncodedValue.getBooleanEncodedValue(valueArg);
            }
        }
        return null;
    }

    @Override
    public int compareTo(EncodedValue o) {
        int comp = this.getValueType().compareTo(o.getValueType());
        if (comp == 0) {
            comp = this.compareValue(o);
        }
        return comp;
    }

    protected abstract int compareValue(EncodedValue var1);

    public abstract ValueType getValueType();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof EncodedValue)) {
            return false;
        }
        return this.compareTo((EncodedValue)o) == 0;
    }
}

