/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.program.model.address.Address;
import ghidra.program.model.data.AbstractIntegerDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.DynamicEntry;
import ghidra.program.model.pcode.GlobalSymbolMap;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.HighFunctionDBUtil;
import ghidra.program.model.pcode.HighSymbol;
import ghidra.program.model.pcode.HighVariable;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.PcodeXMLException;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.pcode.VarnodeAST;
import ghidra.program.model.scalar.Scalar;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;

public class HighConstant
extends HighVariable {
    private HighSymbol symbol;
    private Address pcaddr;

    public HighConstant(HighFunction func) {
        super(func);
    }

    public HighConstant(String name, DataType type, Varnode vn, Address pc, HighFunction func) {
        super(name, type, vn, null, func);
        this.pcaddr = pc;
    }

    @Override
    public HighSymbol getSymbol() {
        return this.symbol;
    }

    public Address getPCAddress() {
        return this.pcaddr;
    }

    public Scalar getScalar() {
        boolean signed = false;
        long value = this.getRepresentative().getOffset();
        DataType dt = this.getDataType();
        if (dt instanceof AbstractIntegerDataType) {
            signed = ((AbstractIntegerDataType)dt).isSigned();
        }
        if (signed) {
            int bitLength = this.getSize() * 8;
            int shiftCnt = 64 - bitLength;
            value <<= shiftCnt;
            value >>= shiftCnt;
        }
        return new Scalar(this.getSize() * 8, value, signed);
    }

    @Override
    public void restoreXml(XmlPullParser parser) throws PcodeXMLException {
        XmlElement el = parser.start(new String[]{"high"});
        long symref = SpecXmlUtils.decodeLong((String)el.getAttribute("symref"));
        this.restoreInstances(parser, el);
        this.pcaddr = this.function.getPCAddress(this.represent);
        if (symref != 0L) {
            this.symbol = this.function.getLocalSymbolMap().getSymbol(symref);
            if (this.symbol == null) {
                this.symbol = this.function.getGlobalSymbolMap().getSymbol(symref);
            }
            if (this.symbol == null) {
                PcodeOp op;
                Address addr;
                GlobalSymbolMap globalMap = this.function.getGlobalSymbolMap();
                Program program = this.function.getFunction().getProgram();
                this.symbol = globalMap.populateSymbol(symref, null, -1);
                if (this.symbol == null && (addr = HighFunctionDBUtil.getSpacebaseReferenceAddress(program, op = ((VarnodeAST)this.represent).getLoneDescend())) != null) {
                    this.symbol = globalMap.newSymbol(symref, addr, DataType.DEFAULT, 1);
                }
            } else if (this.symbol.getFirstWholeMap() instanceof DynamicEntry) {
                this.name = this.symbol.getName();
                this.symbol.setHighVariable(this);
            }
        }
        parser.end(el);
    }
}

