/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.program.model.data.AbstractIntegerDataType;
import ghidra.program.model.data.DataOrganization;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.ShortDataType;

public class UnsignedShortDataType
extends AbstractIntegerDataType {
    private static final long serialVersionUID = 1L;
    public static final UnsignedShortDataType dataType = new UnsignedShortDataType();

    public UnsignedShortDataType() {
        this(null);
    }

    public UnsignedShortDataType(DataTypeManager dtm) {
        super("ushort", false, dtm);
    }

    @Override
    public int getLength() {
        return this.getDataOrganization().getShortSize();
    }

    @Override
    public boolean hasLanguageDependantLength() {
        return true;
    }

    @Override
    public String getDescription() {
        return "Unsigned Short Integer (compiler-specific size)";
    }

    @Override
    public String getCDeclaration() {
        return "unsigned short";
    }

    @Override
    public ShortDataType getOppositeSignednessDataType() {
        return ShortDataType.dataType.clone(this.getDataTypeManager());
    }

    @Override
    public UnsignedShortDataType clone(DataTypeManager dtm) {
        if (dtm == this.getDataTypeManager()) {
            return this;
        }
        return new UnsignedShortDataType(dtm);
    }

    @Override
    public String getCTypeDeclaration(DataOrganization dataOrganization) {
        return this.getCTypeDeclaration(this.getName(), "unsigned short", false);
    }
}

