/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.program.model.data.Array;
import ghidra.program.model.data.BitFieldDataType;
import ghidra.program.model.data.BitFieldPacking;
import ghidra.program.model.data.BitFieldPackingImpl;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataOrganization;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Dynamic;
import ghidra.program.model.data.FactoryDataType;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.lang.Language;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.NoValueException;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;

public class DataOrganizationImpl
implements DataOrganization {
    private int absoluteMaxAlignment = 0;
    private int machineAlignment = 8;
    private int defaultAlignment = 1;
    private int defaultPointerAlignment = 4;
    private int pointerShift = 0;
    private int pointerSize = 4;
    private int charSize = 1;
    private int wideCharSize = 2;
    private int shortSize = 2;
    private int integerSize = 4;
    private int longSize = 4;
    private int longLongSize = 8;
    private int floatSize = 4;
    private int doubleSize = 8;
    private int longDoubleSize = 8;
    private boolean bigEndian = false;
    private boolean isSignedChar = true;
    private BitFieldPackingImpl bitFieldPacking = new BitFieldPackingImpl();
    private final HashMap<Integer, Integer> sizeAlignmentMap = new HashMap();

    public static DataOrganization getDefaultOrganization() {
        return DataOrganizationImpl.getDefaultOrganization(null);
    }

    public static DataOrganizationImpl getDefaultOrganization(Language language) {
        DataOrganizationImpl dataOrganization = new DataOrganizationImpl();
        dataOrganization.setSizeAlignment(1, 1);
        dataOrganization.setSizeAlignment(2, 2);
        dataOrganization.setSizeAlignment(4, 4);
        dataOrganization.setSizeAlignment(8, 4);
        if (language != null) {
            dataOrganization.setPointerSize(language.getDefaultSpace().getPointerSize());
            dataOrganization.setBigEndian(language.isBigEndian());
        }
        return dataOrganization;
    }

    private DataOrganizationImpl() {
    }

    @Override
    public boolean isBigEndian() {
        return this.bigEndian;
    }

    @Override
    public int getPointerSize() {
        return this.pointerSize;
    }

    @Override
    public int getPointerShift() {
        return this.pointerShift;
    }

    @Override
    public boolean isSignedChar() {
        return this.isSignedChar;
    }

    @Override
    public int getCharSize() {
        return this.charSize;
    }

    @Override
    public int getWideCharSize() {
        return this.wideCharSize;
    }

    @Override
    public int getShortSize() {
        return this.shortSize;
    }

    @Override
    public int getIntegerSize() {
        return this.integerSize;
    }

    @Override
    public int getLongSize() {
        return this.longSize;
    }

    @Override
    public int getLongLongSize() {
        return this.longLongSize;
    }

    @Override
    public int getFloatSize() {
        return this.floatSize;
    }

    @Override
    public int getDoubleSize() {
        return this.doubleSize;
    }

    @Override
    public int getLongDoubleSize() {
        return this.longDoubleSize;
    }

    @Override
    public BitFieldPacking getBitFieldPacking() {
        return this.bitFieldPacking;
    }

    public void setBigEndian(boolean bigEndian) {
        this.bigEndian = bigEndian;
    }

    public void setPointerSize(int pointerSize) {
        this.pointerSize = pointerSize;
    }

    public void setPointerShift(int pointerShift) {
        this.pointerShift = pointerShift;
    }

    public void setCharIsSigned(boolean signed) {
        this.isSignedChar = signed;
    }

    public void setCharSize(int charSize) {
        this.charSize = charSize;
    }

    public void setWideCharSize(int wideCharSize) {
        this.wideCharSize = wideCharSize;
    }

    public void setShortSize(int shortSize) {
        this.shortSize = shortSize;
        if (this.integerSize < shortSize) {
            this.setIntegerSize(shortSize);
        }
    }

    public void setIntegerSize(int integerSize) {
        this.integerSize = integerSize;
        if (this.longSize < integerSize) {
            this.setLongSize(integerSize);
        }
        if (this.shortSize > integerSize) {
            this.setShortSize(integerSize);
        }
    }

    public void setLongSize(int longSize) {
        this.longSize = longSize;
        if (this.longLongSize < longSize) {
            this.setLongLongSize(longSize);
        }
        if (this.integerSize > longSize) {
            this.setIntegerSize(longSize);
        }
    }

    public void setLongLongSize(int longLongSize) {
        this.longLongSize = longLongSize;
        if (this.longSize > longLongSize) {
            this.setLongSize(longLongSize);
        }
    }

    public void setFloatSize(int floatSize) {
        this.floatSize = floatSize;
        if (this.doubleSize < floatSize) {
            this.setDoubleSize(floatSize);
        }
    }

    public void setDoubleSize(int doubleSize) {
        this.doubleSize = doubleSize;
        if (this.longDoubleSize < doubleSize) {
            this.setLongDoubleSize(doubleSize);
        }
        if (this.floatSize > doubleSize) {
            this.setFloatSize(doubleSize);
        }
    }

    public void setLongDoubleSize(int longDoubleSize) {
        this.longDoubleSize = longDoubleSize;
        if (this.doubleSize > longDoubleSize) {
            this.setDoubleSize(longDoubleSize);
        }
    }

    @Override
    public int getAbsoluteMaxAlignment() {
        return this.absoluteMaxAlignment;
    }

    @Override
    public int getMachineAlignment() {
        return this.machineAlignment;
    }

    @Override
    public int getDefaultAlignment() {
        return this.defaultAlignment;
    }

    @Override
    public int getDefaultPointerAlignment() {
        return this.defaultPointerAlignment;
    }

    public void setAbsoluteMaxAlignment(int absoluteMaxAlignment) {
        this.absoluteMaxAlignment = absoluteMaxAlignment;
    }

    public void setMachineAlignment(int machineAlignment) {
        this.machineAlignment = machineAlignment;
    }

    public void setDefaultAlignment(int defaultAlignment) {
        this.defaultAlignment = defaultAlignment;
    }

    public void setDefaultPointerAlignment(int defaultPointerAlignment) {
        this.defaultPointerAlignment = defaultPointerAlignment;
    }

    @Override
    public int getSizeAlignment(int size) throws NoValueException {
        return this.sizeAlignmentMap.get(size);
    }

    public void setSizeAlignment(int size, int alignment) {
        this.sizeAlignmentMap.put(size, alignment);
    }

    public void setBitFieldPacking(BitFieldPackingImpl bitFieldPacking) {
        this.bitFieldPacking = bitFieldPacking;
    }

    public void clearSizeAlignmentMap() {
        this.sizeAlignmentMap.clear();
    }

    @Override
    public int getSizeAlignmentCount() {
        return this.sizeAlignmentMap.size();
    }

    @Override
    public int[] getSizes() {
        Set<Integer> keySet = this.sizeAlignmentMap.keySet();
        int[] keys = new int[keySet.size()];
        int index = 0;
        for (Integer k : keySet) {
            keys[index++] = k;
        }
        Arrays.sort(keys);
        return keys;
    }

    @Override
    public String getIntegerCTypeApproximation(int size, boolean signed) {
        Object ctype = "long long";
        if (size <= 1) {
            ctype = "char";
        } else if (size <= this.getShortSize() && this.getShortSize() != this.getIntegerSize()) {
            ctype = "short";
        } else if (size <= this.getIntegerSize()) {
            ctype = "int";
        } else if (size <= this.getLongSize()) {
            ctype = "long";
        }
        if (!signed) {
            ctype = "unsigned " + (String)ctype;
        }
        return ctype;
    }

    @Override
    public int getAlignment(DataType dataType) {
        int dtSize = dataType.getLength();
        if (dataType instanceof Dynamic || dataType instanceof FactoryDataType || dtSize <= 0) {
            return 1;
        }
        if (dataType instanceof TypeDef) {
            return this.getAlignment(((TypeDef)dataType).getBaseDataType());
        }
        if (dataType instanceof Array) {
            DataType elementDt = ((Array)dataType).getDataType();
            return this.getAlignment(elementDt);
        }
        if (dataType instanceof Composite) {
            return ((Composite)dataType).getAlignment();
        }
        if (dataType instanceof BitFieldDataType) {
            BitFieldDataType bitfieldDt = (BitFieldDataType)dataType;
            return this.getAlignment(bitfieldDt.getBaseDataType());
        }
        if (this.sizeAlignmentMap.containsKey(dtSize)) {
            int sizeAlignment = this.sizeAlignmentMap.get(dtSize);
            return this.absoluteMaxAlignment == 0 || sizeAlignment < this.absoluteMaxAlignment ? sizeAlignment : this.absoluteMaxAlignment;
        }
        if (dataType instanceof Pointer) {
            return this.getDefaultPointerAlignment();
        }
        return this.getDefaultAlignment();
    }

    public static int getAlignedOffset(int alignment, int minimumOffset) {
        if (alignment <= 0) {
            return minimumOffset;
        }
        if ((alignment & 1) == 0) {
            return alignment + (minimumOffset - 1 & ~(alignment - 1));
        }
        int offcut = minimumOffset % alignment;
        int adj = offcut != 0 ? alignment - offcut : 0;
        return minimumOffset + adj;
    }

    public static int getLeastCommonMultiple(int value1, int value2) {
        int gcd = DataOrganizationImpl.getGreatestCommonDenominator(value1, value2);
        return gcd != 0 ? value1 / gcd * value2 : 0;
    }

    public static int getGreatestCommonDenominator(int value1, int value2) {
        return value2 != 0 ? DataOrganizationImpl.getGreatestCommonDenominator(value2, value1 % value2) : value1;
    }

    public void saveXml(StringBuilder buffer) {
        buffer.append("<data_organization>\n");
        if (this.absoluteMaxAlignment != 0) {
            buffer.append("<absolute_max_alignment");
            SpecXmlUtils.encodeSignedIntegerAttribute((StringBuilder)buffer, (String)"value", (long)this.absoluteMaxAlignment);
            buffer.append("/>\n");
        }
        if (this.machineAlignment != 8) {
            buffer.append("<machine_alignment");
            SpecXmlUtils.encodeSignedIntegerAttribute((StringBuilder)buffer, (String)"value", (long)this.machineAlignment);
            buffer.append("/>\n");
        }
        if (this.defaultAlignment != 1) {
            buffer.append("<default_alignment");
            SpecXmlUtils.encodeSignedIntegerAttribute((StringBuilder)buffer, (String)"value", (long)this.defaultAlignment);
            buffer.append("/>\n");
        }
        if (this.defaultPointerAlignment != 4) {
            buffer.append("<default_pointer_alignment");
            SpecXmlUtils.encodeSignedIntegerAttribute((StringBuilder)buffer, (String)"value", (long)this.defaultPointerAlignment);
            buffer.append("/>\n");
        }
        if (this.pointerSize != 0) {
            buffer.append("<pointer_size");
            SpecXmlUtils.encodeSignedIntegerAttribute((StringBuilder)buffer, (String)"value", (long)this.pointerSize);
            buffer.append("/>\n");
        }
        if (this.pointerShift != 0) {
            buffer.append("<pointer_shift");
            SpecXmlUtils.encodeSignedIntegerAttribute((StringBuilder)buffer, (String)"value", (long)this.pointerShift);
            buffer.append("/>\n");
        }
        if (!this.isSignedChar) {
            buffer.append("<char_type signed=\"no\"/>\n");
        }
        if (this.charSize != 1) {
            buffer.append("<char_size");
            SpecXmlUtils.encodeSignedIntegerAttribute((StringBuilder)buffer, (String)"value", (long)this.charSize);
            buffer.append("/>\n");
        }
        if (this.wideCharSize != 2) {
            buffer.append("<wchar_size");
            SpecXmlUtils.encodeSignedIntegerAttribute((StringBuilder)buffer, (String)"value", (long)this.wideCharSize);
            buffer.append("/>\n");
        }
        if (this.shortSize != 2) {
            buffer.append("<short_size");
            SpecXmlUtils.encodeSignedIntegerAttribute((StringBuilder)buffer, (String)"value", (long)this.shortSize);
            buffer.append("/>\n");
        }
        if (this.integerSize != 4) {
            buffer.append("<integer_size");
            SpecXmlUtils.encodeSignedIntegerAttribute((StringBuilder)buffer, (String)"value", (long)this.integerSize);
            buffer.append("/>\n");
        }
        if (this.longSize != 4) {
            buffer.append("<long_size");
            SpecXmlUtils.encodeSignedIntegerAttribute((StringBuilder)buffer, (String)"value", (long)this.longSize);
            buffer.append("/>\n");
        }
        if (this.longLongSize != 8) {
            buffer.append("<long_long_size");
            SpecXmlUtils.encodeSignedIntegerAttribute((StringBuilder)buffer, (String)"value", (long)this.longLongSize);
            buffer.append("/>\n");
        }
        if (this.floatSize != 4) {
            buffer.append("<float_size");
            SpecXmlUtils.encodeSignedIntegerAttribute((StringBuilder)buffer, (String)"value", (long)this.floatSize);
            buffer.append("/>\n");
        }
        if (this.doubleSize != 8) {
            buffer.append("<double_size");
            SpecXmlUtils.encodeSignedIntegerAttribute((StringBuilder)buffer, (String)"value", (long)this.doubleSize);
            buffer.append("/>\n");
        }
        if (this.longDoubleSize != 8) {
            buffer.append("<long_double_size");
            SpecXmlUtils.encodeSignedIntegerAttribute((StringBuilder)buffer, (String)"value", (long)this.longDoubleSize);
            buffer.append("/>\n");
        }
        if (this.sizeAlignmentMap.size() != 0) {
            buffer.append("<size_alignment_map>\n");
            for (int key : this.sizeAlignmentMap.keySet()) {
                buffer.append("<entry");
                int value = this.sizeAlignmentMap.get(key);
                SpecXmlUtils.encodeSignedIntegerAttribute((StringBuilder)buffer, (String)"size", (long)key);
                SpecXmlUtils.encodeSignedIntegerAttribute((StringBuilder)buffer, (String)"alignment", (long)value);
                buffer.append("/>\n");
            }
            buffer.append("</size_alignment_map>\n");
        }
        this.bitFieldPacking.saveXml(buffer);
        buffer.append("</data_organization>\n");
    }

    public void restoreXml(XmlPullParser parser) {
        parser.start(new String[0]);
        while (parser.peek().isStart()) {
            XmlElement subel;
            String name = parser.peek().getName();
            if (name.equals("char_type")) {
                subel = parser.start(new String[0]);
                String boolStr = subel.getAttribute("signed");
                this.isSignedChar = SpecXmlUtils.decodeBoolean((String)boolStr);
                parser.end(subel);
                continue;
            }
            if (name.equals("bitfield_packing")) {
                this.bitFieldPacking.restoreXml(parser);
                continue;
            }
            if (name.equals("size_alignment_map")) {
                subel = parser.start(new String[0]);
                while (parser.peek().isStart()) {
                    XmlElement subsubel = parser.start(new String[0]);
                    int size = SpecXmlUtils.decodeInt((String)subsubel.getAttribute("size"));
                    int alignment = SpecXmlUtils.decodeInt((String)subsubel.getAttribute("alignment"));
                    this.sizeAlignmentMap.put(size, alignment);
                    parser.end(subsubel);
                }
                parser.end(subel);
                continue;
            }
            subel = parser.start(new String[0]);
            String value = subel.getAttribute("value");
            if (name.equals("absolute_max_alignment")) {
                this.absoluteMaxAlignment = SpecXmlUtils.decodeInt((String)value);
            } else if (name.equals("machine_alignment")) {
                this.machineAlignment = SpecXmlUtils.decodeInt((String)value);
            } else if (name.equals("default_alignment")) {
                this.defaultAlignment = SpecXmlUtils.decodeInt((String)value);
            } else if (name.equals("default_pointer_alignment")) {
                this.defaultPointerAlignment = SpecXmlUtils.decodeInt((String)value);
            } else if (name.equals("pointer_size")) {
                this.pointerSize = SpecXmlUtils.decodeInt((String)value);
            } else if (name.equals("pointer_shift")) {
                this.pointerShift = SpecXmlUtils.decodeInt((String)value);
            } else if (name.equals("char_size")) {
                this.charSize = SpecXmlUtils.decodeInt((String)value);
            } else if (name.equals("wchar_size")) {
                this.wideCharSize = SpecXmlUtils.decodeInt((String)value);
            } else if (name.equals("short_size")) {
                this.shortSize = SpecXmlUtils.decodeInt((String)value);
            } else if (name.equals("integer_size")) {
                this.integerSize = SpecXmlUtils.decodeInt((String)value);
            } else if (name.equals("long_size")) {
                this.longSize = SpecXmlUtils.decodeInt((String)value);
            } else if (name.equals("long_long_size")) {
                this.longLongSize = SpecXmlUtils.decodeInt((String)value);
            } else if (name.equals("float_size")) {
                this.floatSize = SpecXmlUtils.decodeInt((String)value);
            } else if (name.equals("double_size")) {
                this.doubleSize = SpecXmlUtils.decodeInt((String)value);
            } else if (name.equals("long_double_size")) {
                this.longDoubleSize = SpecXmlUtils.decodeInt((String)value);
            }
            parser.end(subel);
        }
        parser.end();
    }

    public boolean equals(Object obj) {
        DataOrganizationImpl op2 = (DataOrganizationImpl)obj;
        if (this.absoluteMaxAlignment != op2.absoluteMaxAlignment) {
            return false;
        }
        if (this.bigEndian != op2.bigEndian) {
            return false;
        }
        if (!this.bitFieldPacking.equals(op2.bitFieldPacking)) {
            return false;
        }
        if (this.charSize != op2.charSize || this.wideCharSize != op2.wideCharSize) {
            return false;
        }
        if (this.defaultAlignment != op2.defaultAlignment) {
            return false;
        }
        if (this.defaultPointerAlignment != op2.defaultPointerAlignment) {
            return false;
        }
        if (this.doubleSize != op2.doubleSize || this.floatSize != op2.floatSize) {
            return false;
        }
        if (this.integerSize != op2.integerSize || this.longLongSize != op2.longLongSize) {
            return false;
        }
        if (this.shortSize != op2.shortSize) {
            return false;
        }
        if (this.longSize != op2.longSize || this.longDoubleSize != op2.longDoubleSize) {
            return false;
        }
        if (this.isSignedChar != op2.isSignedChar) {
            return false;
        }
        if (this.machineAlignment != op2.machineAlignment) {
            return false;
        }
        if (this.pointerSize != op2.pointerSize || this.pointerShift != op2.pointerShift) {
            return false;
        }
        Set<Integer> keys = this.sizeAlignmentMap.keySet();
        Set<Integer> op2keys = op2.sizeAlignmentMap.keySet();
        if (keys.size() != op2keys.size()) {
            return false;
        }
        for (int k : keys) {
            if (SystemUtilities.isEqual((Object)this.sizeAlignmentMap.get(k), (Object)op2.sizeAlignmentMap.get(k))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = this.bitFieldPacking.hashCode();
        hash = 79 * hash + this.absoluteMaxAlignment;
        hash = 79 * hash + (this.bigEndian ? 27 : 13);
        hash = 79 * hash + this.charSize;
        hash = 79 * hash + this.defaultAlignment;
        hash = 79 * hash + this.defaultPointerAlignment;
        hash = 79 * hash + this.doubleSize;
        hash = 79 * hash + this.floatSize;
        hash = 79 * hash + this.integerSize;
        hash = 79 * hash + (this.isSignedChar ? 1 : 3);
        hash = 79 * hash + this.longDoubleSize;
        hash = 79 * hash + this.longLongSize;
        hash = 79 * hash + this.longSize;
        hash = 79 * hash + this.machineAlignment;
        hash = 79 * hash + this.pointerShift;
        hash = 79 * hash + this.pointerSize;
        hash = 79 * hash + this.shortSize;
        hash = 79 * hash + this.wideCharSize;
        for (int k : this.sizeAlignmentMap.keySet()) {
            hash = 79 * hash + this.sizeAlignmentMap.get(k);
        }
        return hash;
    }
}

