/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.program.model.data.BitFieldPacking;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;

public class BitFieldPackingImpl
implements BitFieldPacking {
    private boolean useMSConvention = false;
    private boolean typeAlignmentEnabled = true;
    private int zeroLengthBoundary = 0;

    @Override
    public boolean useMSConvention() {
        return this.useMSConvention;
    }

    @Override
    public boolean isTypeAlignmentEnabled() {
        return this.useMSConvention || this.typeAlignmentEnabled;
    }

    @Override
    public int getZeroLengthBoundary() {
        return this.useMSConvention ? 0 : this.zeroLengthBoundary;
    }

    public void setUseMSConvention(boolean useMSConvention) {
        this.useMSConvention = useMSConvention;
    }

    public void setTypeAlignmentEnabled(boolean typeAlignmentEnabled) {
        this.typeAlignmentEnabled = typeAlignmentEnabled;
    }

    public void setZeroLengthBoundary(int zeroLengthBoundary) {
        this.zeroLengthBoundary = zeroLengthBoundary;
    }

    public void saveXml(StringBuilder buffer) {
        if (!this.useMSConvention && this.typeAlignmentEnabled && this.zeroLengthBoundary == 0) {
            return;
        }
        buffer.append("<bitfield_packing>\n");
        if (this.useMSConvention) {
            buffer.append("<use_MS_convention value=\"yes\"/>\n");
        }
        if (!this.typeAlignmentEnabled) {
            buffer.append("<type_alignment_enabled value=\"no\"/>\n");
        }
        if (this.zeroLengthBoundary != 0) {
            buffer.append("<zero_length_boundary");
            SpecXmlUtils.encodeSignedIntegerAttribute((StringBuilder)buffer, (String)"value", (long)this.zeroLengthBoundary);
            buffer.append("/>\n");
        }
        buffer.append("</bitfield_packing>\n");
    }

    protected void restoreXml(XmlPullParser parser) {
        parser.start(new String[0]);
        while (parser.peek().isStart()) {
            XmlElement subel = parser.start(new String[0]);
            String name = subel.getName();
            String value = subel.getAttribute("value");
            if (name.equals("use_MS_convention")) {
                this.useMSConvention = SpecXmlUtils.decodeBoolean((String)value);
            } else if (name.equals("type_alignment_enabled")) {
                this.typeAlignmentEnabled = SpecXmlUtils.decodeBoolean((String)value);
            } else if (name.equals("zero_length_boundary")) {
                this.zeroLengthBoundary = SpecXmlUtils.decodeInt((String)value);
            }
            parser.end(subel);
        }
        parser.end();
    }

    public boolean equals(Object obj) {
        BitFieldPackingImpl op2 = (BitFieldPackingImpl)obj;
        if (this.typeAlignmentEnabled != op2.typeAlignmentEnabled) {
            return false;
        }
        if (this.useMSConvention != op2.useMSConvention) {
            return false;
        }
        return this.zeroLengthBoundary == op2.zeroLengthBoundary;
    }

    public int hashCode() {
        return (this.typeAlignmentEnabled ? 1 : 13) + (this.useMSConvention ? 5 : 27) + this.zeroLengthBoundary;
    }
}

