/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.symbol;

import db.DBRecord;
import ghidra.program.database.DBObjectCache;
import ghidra.program.database.symbol.LibraryDB;
import ghidra.program.database.symbol.SymbolDB;
import ghidra.program.database.symbol.SymbolManager;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.CircularDependencyException;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.SymbolType;
import ghidra.program.util.ProgramLocation;
import ghidra.util.Msg;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;

public class LibrarySymbol
extends SymbolDB {
    private LibraryDB library;

    public LibrarySymbol(SymbolManager symbolMgr, DBObjectCache<SymbolDB> cache, Address address, DBRecord record) {
        super(symbolMgr, cache, address, record);
    }

    @Override
    public void setName(String newName, SourceType source) throws DuplicateNameException, InvalidInputException {
        String oldName = this.getName();
        if ("<EXTERNAL>".equals(oldName)) {
            Msg.warn((Object)this, (Object)"Unable to change name of <EXTERNAL> Library");
            return;
        }
        super.setName(newName, source);
        if (!oldName.equals(this.getName())) {
            this.symbolMgr.getProgram().setObjChanged(68, (Address)null, null, (Object)oldName, (Object)newName);
        }
    }

    @Override
    public void setNameAndNamespace(String newName, Namespace newNamespace, SourceType source) throws DuplicateNameException, InvalidInputException, CircularDependencyException {
        String oldName = this.getName();
        super.setNameAndNamespace(newName, newNamespace, source);
        if (!oldName.equals(this.getName())) {
            this.symbolMgr.getProgram().setObjChanged(68, (Address)null, null, (Object)oldName, (Object)newName);
        }
    }

    @Override
    public void setSymbolStringData(String newPath) {
        String oldPath = this.getSymbolStringData();
        super.setSymbolStringData(newPath);
        this.symbolMgr.getProgram().setObjChanged(65, this.getName(), oldPath, newPath);
    }

    @Override
    public SymbolType getSymbolType() {
        return SymbolType.LIBRARY;
    }

    @Override
    public boolean isExternal() {
        return true;
    }

    @Override
    public Object getObject() {
        if (this.library == null) {
            this.library = new LibraryDB(this, this.symbolMgr.getProgram().getNamespaceManager());
        }
        return this.library;
    }

    @Override
    public boolean isPrimary() {
        return true;
    }

    @Override
    public ProgramLocation getProgramLocation() {
        return null;
    }

    @Override
    public boolean isValidParent(Namespace parent) {
        return SymbolType.LIBRARY.isValidParent(this.symbolMgr.getProgram(), parent, this.address, this.isExternal());
    }
}

